/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import jetbrick.io.resource.FileSystemResource;
import jetbrick.io.resource.Resource;
import jetbrick.io.resource.ResourceUtils;
import jetbrick.typecast.Convertor;
import jetbrick.util.JdkUtils;

public final class ResourceConvertor
implements Convertor<Resource> {
    public static final ResourceConvertor INSTANCE = new ResourceConvertor();

    @Override
    public Resource convert(String value) {
        if (value == null) {
            return null;
        }
        return ResourceUtils.create(value);
    }

    @Override
    public Resource convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Resource) {
            return (Resource)value;
        }
        if (value instanceof String) {
            return ResourceUtils.create((String)value);
        }
        if (value instanceof File) {
            return new FileSystemResource((File)value);
        }
        if (value.getClass() == URL.class) {
            return ResourceUtils.create((URL)value);
        }
        if (value.getClass() == URI.class) {
            try {
                return ResourceUtils.create(((URI)value).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        if (JdkUtils.IS_AT_LEAST_JAVA_7 && value instanceof Path) {
            return new FileSystemResource(((Path)value).toFile());
        }
        return this.convert(value.toString());
    }
}

