/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

public class WildcharUtils {
    public static boolean match(String string, String pattern) {
        if (string.equals(pattern)) {
            return true;
        }
        return WildcharUtils.match(string, pattern, 0, 0);
    }

    public static int matchOne(String src, String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!WildcharUtils.match(src, patterns[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean match(String string, String pattern, int sNdx, int pNdx) {
        int pLen = pattern.length();
        if (pLen == 1 && pattern.charAt(0) == '*') {
            return true;
        }
        int sLen = string.length();
        boolean nextIsNotWildcard = false;
        while (true) {
            if (sNdx >= sLen) {
                while (pNdx < pLen && pattern.charAt(pNdx) == '*') {
                    ++pNdx;
                }
                return pNdx >= pLen;
            }
            if (pNdx >= pLen) {
                return false;
            }
            char p = pattern.charAt(pNdx);
            if (!nextIsNotWildcard) {
                if (p == '\\') {
                    ++pNdx;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (p == '?') {
                    ++sNdx;
                    ++pNdx;
                    continue;
                }
                if (p == '*') {
                    int pNext = 0;
                    if (pNdx + 1 < pLen) {
                        pNext = pattern.charAt(pNdx + 1);
                    }
                    if (pNext == 42) {
                        ++pNdx;
                        continue;
                    }
                    ++pNdx;
                    for (int i = string.length(); i >= sNdx; --i) {
                        if (!WildcharUtils.match(string, pattern, i, pNdx)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (p != string.charAt(sNdx)) {
                return false;
            }
            ++sNdx;
            ++pNdx;
        }
    }
}

