/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import jetbrick.util.ArrayUtils;
import jetbrick.util.JSONUtils;
import jetbrick.util.StringUtils;
import jetbrick.util.codec.Base64Utils;

public final class RequestUtils {
    public static String getPathInfo(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (pathInfo != null) {
                uri = uri + pathInfo;
            }
        } else {
            uri = request.getServletPath();
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                uri = uri + pathInfo;
            }
        }
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        return uri;
    }

    public static String getParametersAsJSON(HttpServletRequest request) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String[] value = request.getParameterValues(name);
            if (value == null || value.length == 0) continue;
            if (value.length > 1) {
                json.put(name, value);
                continue;
            }
            json.put(name, value[0]);
        }
        return JSONUtils.toJSONString(json);
    }

    public static String getUrlWithParameters(HttpServletRequest request, String excludeNames) {
        Object[] excludeNamesArray = ArrayUtils.EMPTY_STRING_ARRAY;
        if (excludeNames != null) {
            excludeNamesArray = StringUtils.split(excludeNames, ',');
        }
        StringBuffer sb = new StringBuffer();
        String encoding = request.getCharacterEncoding();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String[] value;
            String name = (String)enu.nextElement();
            if (ArrayUtils.contains(excludeNamesArray, name) || (value = request.getParameterValues(name)) == null) continue;
            for (int i = 0; i < value.length; ++i) {
                try {
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    sb.append(name).append('=').append(URLEncoder.encode(value[i], encoding));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        if (sb.length() > 0) {
            sb.insert(0, '?');
        }
        sb.insert(0, request.getContextPath() + RequestUtils.getPathInfo(request));
        return sb.toString();
    }

    public static String getClientIPAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-real-ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static int getParameterAsInteger(HttpServletRequest request, String key, int defaultValue) {
        String value = request.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getParameterAsLong(HttpServletRequest request, String key, long defaultValue) {
        String value = request.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getParameterAsBoolean(HttpServletRequest request, String key, boolean defaultValue) {
        String value = request.getParameter(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value.equals("true") || value.equals("1") || value.equals("yes") || value.equals("y") || value.equals("on");
    }

    public static String encodeHttpBasic(String userName, String password) {
        String encode = userName + ":" + password;
        return "Basic " + Base64Utils.encodeToString(encode.getBytes());
    }

    public static String getAuthUsername(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header == null) {
            return null;
        }
        String encoded = header.substring(header.indexOf(32) + 1);
        String decoded = Base64Utils.decodeToString(encoded);
        return decoded.substring(0, decoded.indexOf(58));
    }

    public static String getAuthPassword(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header == null) {
            return null;
        }
        String encoded = header.substring(header.indexOf(32) + 1);
        String decoded = Base64Utils.decodeToString(encoded);
        return decoded.substring(decoded.indexOf(58) + 1);
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With")) || request.getHeader("accept").contains("application/json");
    }

    public static boolean isPjaxRequest(HttpServletRequest request) {
        return StringUtils.isNotEmpty(request.getHeader("X-PJAX"));
    }

    public static boolean isFlashRequest(HttpServletRequest request) {
        return "Shockwave Flash".equals(request.getHeader("User-Agent")) || StringUtils.isNotEmpty(request.getHeader("x-flash-version"));
    }

    public static boolean isMultipartRequest(HttpServletRequest request) {
        String type = request.getHeader("Content-Type");
        return type != null && type.startsWith("multipart/form-data");
    }

    public static boolean isGzipSupported(HttpServletRequest request) {
        String browserEncodings = request.getHeader("Accept-Encoding");
        return browserEncodings != null && browserEncodings.contains("gzip");
    }

    public static boolean isRobot(HttpServletRequest request) {
        String ua = request.getHeader("user-agent");
        if (StringUtils.isBlank(ua)) {
            return false;
        }
        return ua != null && (ua.contains("Baiduspider") || ua.contains("Googlebot") || ua.contains("sogou") || ua.contains("sina") || ua.contains("iaskspider") || ua.contains("ia_archiver") || ua.contains("Sosospider") || ua.contains("YoudaoBot") || ua.contains("yahoo") || ua.contains("yodao") || ua.contains("MSNBot") || ua.contains("spider") || ua.contains("Twiceler") || ua.contains("Sosoimagespider") || ua.contains("naver.com/robots") || ua.contains("Nutch") || ua.contains("spider"));
    }
}

