/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.servlet.map;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class StringEnumeratedMap<V>
implements Map<String, V> {
    private volatile Map<String, V> map;

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getAsMap().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getAttribute(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return this.getAsMap().isEmpty();
    }

    @Override
    public int size() {
        return this.getAsMap().size();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.getAsMap().entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.getAsMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getAsMap().values();
    }

    @Override
    public synchronized V put(String key, V value) {
        this.map = null;
        V previous = this.get(key);
        this.setAttribute(key, value);
        return previous;
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends V> m) {
        this.map = null;
        for (Map.Entry<String, V> e : m.entrySet()) {
            this.setAttribute(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized V remove(Object key) {
        this.map = null;
        V value = this.get(key);
        this.removeAttribute(key.toString());
        return value;
    }

    @Override
    public synchronized void clear() {
        this.map = null;
        Enumeration<String> keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            this.removeAttribute(keys.nextElement());
        }
    }

    protected abstract Enumeration<String> getAttributeNames();

    protected abstract V getAttribute(String var1);

    protected abstract void setAttribute(String var1, V var2);

    protected abstract void removeAttribute(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, V> getAsMap() {
        Map<String, V> result = this.map;
        if (result == null) {
            StringEnumeratedMap stringEnumeratedMap = this;
            synchronized (stringEnumeratedMap) {
                result = this.map;
                if (result == null) {
                    this.map = result = this.initialize();
                }
            }
        }
        return result;
    }

    private Map<String, V> initialize() {
        HashMap<String, V> map = new HashMap<String, V>();
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            V value = this.getAttribute(key);
            map.put(key, value);
        }
        return map;
    }
}

