/*
 * Decompiled with CFR 0.152.
 */
package com.ibeetl.starter;

import java.util.Properties;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.ext.spring.BeetlGroupUtilConfiguration;
import org.beetl.ext.spring.BeetlSpringViewResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"beetl.enabled"}, havingValue="true", matchIfMissing=true)
public class BeetlTemplateConfig {
    @Value(value="${beetl.templatesPath:templates}")
    String templatesPath;
    @Value(value="${beetl.suffix:btl}")
    String suffix;
    @Value(value="${beetl-beetlsq.dev:true}")
    boolean dev;

    @Bean(name={"beetlConfig"})
    @ConditionalOnMissingBean(name={"beetlConfig"})
    public BeetlGroupUtilConfiguration getBeetlGroupUtilConfiguration() {
        BeetlGroupUtilConfiguration beetlGroupUtilConfiguration = new BeetlGroupUtilConfiguration();
        try {
            ClassLoader loader;
            Properties extProperties = new Properties();
            if (this.dev) {
                extProperties.put("RESOURCE.autoCheck", "true");
            }
            if ((loader = Thread.currentThread().getContextClassLoader()) == null) {
                loader = BeetlTemplateConfig.class.getClassLoader();
            }
            beetlGroupUtilConfiguration.setConfigProperties(extProperties);
            ClasspathResourceLoader cploder = new ClasspathResourceLoader(loader, this.templatesPath);
            beetlGroupUtilConfiguration.setResourceLoader((ResourceLoader)cploder);
            beetlGroupUtilConfiguration.init();
            beetlGroupUtilConfiguration.getGroupTemplate().setClassLoader(loader);
            return beetlGroupUtilConfiguration;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(name={"beetlViewResolver"})
    @ConditionalOnMissingBean(name={"beetlViewResolver"})
    public BeetlSpringViewResolver getBeetlSpringViewResolver(@Qualifier(value="beetlConfig") BeetlGroupUtilConfiguration beetlGroupUtilConfiguration) {
        BeetlSpringViewResolver beetlSpringViewResolver = new BeetlSpringViewResolver();
        beetlSpringViewResolver.setContentType("text/html;charset=UTF-8");
        beetlSpringViewResolver.setViewNames(new String[]{"*." + this.suffix});
        beetlSpringViewResolver.setOrder(0);
        beetlSpringViewResolver.setConfig(beetlGroupUtilConfiguration);
        return beetlSpringViewResolver;
    }

    @Bean(name={"groupTemplate"})
    public GroupTemplate getGroupTemplate(@Qualifier(value="beetlConfig") BeetlGroupUtilConfiguration beetlGroupUtilConfiguration) {
        GroupTemplate gt = beetlGroupUtilConfiguration.getGroupTemplate();
        return gt;
    }
}

