/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om.asm;

import java.util.List;
import org.beetl.core.om.asm.BeanEnhanceUtils;
import org.beetl.core.om.asm.ClassDescription;
import org.beetl.core.om.asm.Constants;
import org.beetl.core.om.asm.FieldDescription;
import org.beetl.ow2.asm.ClassWriter;
import org.beetl.ow2.asm.Label;
import org.beetl.ow2.asm.MethodVisitor;
import org.beetl.ow2.asm.Opcodes;

class EnhanceClassGenerator
implements Opcodes,
Constants {
    private static final int HASH_CODE_INT = "I".hashCode();
    private static final int HASH_CODE_BOOLEAN = "Z".hashCode();
    private static final int HASH_CODE_BYTE = "B".hashCode();
    private static final int HASH_CODE_CHAR = "C".hashCode();
    private static final int HASH_CODE_SHORT = "S".hashCode();
    private static final int HASH_CODE_DOUBLE = "D".hashCode();
    private static final int HASH_CODE_FLOAT = "F".hashCode();
    private static final int HASH_CODE_LONG = "J".hashCode();

    private EnhanceClassGenerator() {
    }

    static byte[] generate(Class<?> beanClass) throws Exception {
        return EnhanceClassGenerator.generate(beanClass, true);
    }

    static byte[] generate(Class<?> beanClass, boolean usePropertyDescriptor) throws Exception {
        return EnhanceClassGenerator.generate(beanClass, "org/beetl/core/om/AttributeAccess", null, usePropertyDescriptor);
    }

    static byte[] generate(Class<?> beanClass, String superName, String[] interfaces, boolean usePropertyDescriptor) throws Exception {
        String beanClassName = beanClass.getName();
        ClassWriter cw = new ClassWriter(1);
        String getterClassName = EnhanceClassGenerator.createGeneratedClassName(beanClassName);
        cw.visit(52, 33, BeanEnhanceUtils.getInternalName(getterClassName), null, superName, interfaces);
        EnhanceClassGenerator.generateDefaultConstruct(cw, superName);
        EnhanceClassGenerator.generateMethod(cw, beanClass, usePropertyDescriptor);
        cw.visitEnd();
        return cw.toByteArray();
    }

    static void generateDefaultConstruct(ClassWriter cw, String superName) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    static String createGeneratedClassName(String className) {
        return className + "$" + "AttributeAccess";
    }

    static String createGeneratedClassName(Class<?> beanClass) {
        return EnhanceClassGenerator.createGeneratedClassName(beanClass.getName());
    }

    private static void generateMethod(ClassWriter cw, Class<?> beanClass, boolean usePropertyDescriptor) {
        String internalClassName = BeanEnhanceUtils.getInternalName(beanClass.getName());
        ClassDescription classDescription = BeanEnhanceUtils.getClassDescription(beanClass, usePropertyDescriptor);
        MethodVisitor mv = cw.visitMethod(1, "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (classDescription.hasField) {
            EnhanceClassGenerator.generateMethodWithFields(internalClassName, classDescription, mv);
        } else {
            EnhanceClassGenerator.generateMethodWithNoField(mv, classDescription, internalClassName);
        }
        mv.visitEnd();
    }

    private static void generateMethodWithFields(String internalClassName, ClassDescription classDescription, MethodVisitor mv) {
        Label toStringLabel = new Label();
        mv.visitLabel(toStringLabel);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
        mv.visitVarInsn(58, 3);
        Label hashCodeLabel = new Label();
        mv.visitLabel(hashCodeLabel);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I", false);
        mv.visitVarInsn(54, 4);
        Label castLabel = new Label();
        mv.visitLabel(castLabel);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, internalClassName);
        mv.visitVarInsn(58, 5);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitVarInsn(21, 4);
        Label[] lookupSwitchLabels = new Label[classDescription.fieldDescMap.size()];
        int[] hashCodes = BeanEnhanceUtils.convertIntegerToPrimitiveType(classDescription.fieldDescMap.keySet().toArray(new Integer[0]));
        for (int i = 0; i < lookupSwitchLabels.length; ++i) {
            lookupSwitchLabels[i] = new Label();
        }
        Label df = new Label();
        mv.visitLookupSwitchInsn(df, hashCodes, lookupSwitchLabels);
        List<FieldDescription> fieldDescs = null;
        FieldDescription curFieldDesc = null;
        for (int i = 0; i < lookupSwitchLabels.length; ++i) {
            fieldDescs = classDescription.fieldDescMap.get(hashCodes[i]);
            mv.visitLabel(lookupSwitchLabels[i]);
            if (i == 0) {
                Object[] locals = new Object[]{"java/lang/String", Opcodes.INTEGER, internalClassName};
                mv.visitFrame(1, locals.length, locals, 0, null);
            } else {
                mv.visitFrame(3, 0, null, 0, null);
            }
            if (fieldDescs.size() == 1) {
                curFieldDesc = fieldDescs.get(0);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, internalClassName, curFieldDesc.readMethodName, curFieldDesc.readMethodDesc, false);
                EnhanceClassGenerator.addInvokeValueOfToPrimitive(mv, curFieldDesc.desc);
                mv.visitInsn(176);
                continue;
            }
            EnhanceClassGenerator.handleSameHashAttr(classDescription, mv, fieldDescs, internalClassName, df);
        }
        if (classDescription.generalGetMethodDesc != null && "java/lang/Object".equals(classDescription.generalGetMethodDesc.parameterInternalName)) {
            mv.visitLabel(df);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 5);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, internalClassName, "get", classDescription.generalGetMethodDesc.desc, false);
            mv.visitInsn(176);
        } else if (classDescription.generalGetMethodDesc != null && "java/lang/String".equals(classDescription.generalGetMethodDesc.parameterInternalName)) {
            mv.visitLabel(df);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 5);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, internalClassName, "get", classDescription.generalGetMethodDesc.desc, false);
            mv.visitInsn(176);
        } else {
            mv.visitLabel(df);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitTypeInsn(187, "org/beetl/core/exception/BeetlException");
            mv.visitInsn(89);
            mv.visitLdcInsn("ATTRIBUTE_NOT_FOUND");
            mv.visitTypeInsn(187, "java/lang/StringBuilder");
            mv.visitInsn(89);
            mv.visitLdcInsn("\u5c5e\u6027\u672a\u627e\u5230(" + classDescription.target.getName() + ") : ");
            mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(183, "org/beetl/core/exception/BeetlException", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", false);
            mv.visitInsn(191);
        }
        mv.visitMaxs(1, 6);
    }

    private static void generateMethodWithNoField(MethodVisitor mv, ClassDescription classDescription, String internalClassName) {
        Label castLabel = new Label();
        mv.visitLabel(castLabel);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, internalClassName);
        mv.visitVarInsn(58, 3);
        Label df = new Label();
        if (classDescription.generalGetMethodDesc != null && "java/lang/Object".equals(classDescription.generalGetMethodDesc.parameterInternalName)) {
            mv.visitLabel(df);
            mv.visitFrame(1, 1, new Object[]{internalClassName}, 0, null);
            mv.visitVarInsn(25, 3);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, internalClassName, "get", classDescription.generalGetMethodDesc.desc, false);
            mv.visitInsn(176);
        } else if (classDescription.generalGetMethodDesc != null && "java/lang/String".equals(classDescription.generalGetMethodDesc.parameterInternalName)) {
            Label toStringLabel = new Label();
            mv.visitLabel(toStringLabel);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
            mv.visitVarInsn(58, 4);
            mv.visitLabel(df);
            mv.visitFrame(1, 2, new Object[]{internalClassName, "java/lang/String"}, 0, null);
            mv.visitVarInsn(25, 3);
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(182, internalClassName, "get", classDescription.generalGetMethodDesc.desc, false);
            mv.visitInsn(176);
        } else {
            Label toStringLabel = new Label();
            mv.visitLabel(toStringLabel);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
            mv.visitVarInsn(58, 4);
            mv.visitLabel(df);
            Object[] locals = new Object[]{internalClassName, "java/lang/String"};
            mv.visitFrame(1, locals.length, locals, 0, null);
            mv.visitTypeInsn(187, "org/beetl/core/exception/BeetlException");
            mv.visitInsn(89);
            mv.visitLdcInsn("ATTRIBUTE_NOT_FOUND");
            mv.visitTypeInsn(187, "java/lang/StringBuilder");
            mv.visitInsn(89);
            mv.visitLdcInsn("attribute : ");
            mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(183, "org/beetl/core/exception/BeetlException", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", false);
            mv.visitInsn(191);
        }
        mv.visitMaxs(1, 4);
    }

    private static void handleSameHashAttr(ClassDescription classDescription, MethodVisitor mv, List<FieldDescription> fieldDescs, String internalClassName, Label defaultLabel) {
        int fieldSize = fieldDescs.size();
        Label[] ifLabels = new Label[fieldSize];
        Label[] invokeLabels = new Label[fieldSize];
        for (int i = 0; i < fieldSize; ++i) {
            ifLabels[i] = new Label();
            invokeLabels[i] = new Label();
        }
        FieldDescription curFieldDesc = null;
        for (int i = 0; i < fieldSize; ++i) {
            if (i != 0) {
                mv.visitLabel(ifLabels[i]);
            }
            curFieldDesc = fieldDescs.get(i);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitLdcInsn(curFieldDesc.name);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
            mv.visitJumpInsn(153, i + 1 == fieldSize ? defaultLabel : ifLabels[i + 1]);
            mv.visitLabel(invokeLabels[i]);
            mv.visitVarInsn(25, 5);
            mv.visitMethodInsn(182, internalClassName, curFieldDesc.readMethodName, curFieldDesc.readMethodDesc, false);
            EnhanceClassGenerator.addInvokeValueOfToPrimitive(mv, curFieldDesc.desc);
            mv.visitInsn(176);
        }
    }

    private static void addInvokeValueOfToPrimitive(MethodVisitor mv, String returnTypeDesc) {
        int opcode = 184;
        String methodName = "valueOf";
        int hashCode = returnTypeDesc.hashCode();
        if (hashCode == HASH_CODE_INT && "I".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java/lang/Integer", methodName, "(I)Ljava/lang/Integer;", false);
        } else if (hashCode == HASH_CODE_BOOLEAN && "Z".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java/lang/Boolean", methodName, "(Z)Ljava/lang/Boolean;", false);
        } else if (hashCode == HASH_CODE_BYTE && "B".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java/lang/Byte", methodName, "(B)Ljava/lang/Byte;", false);
        } else if (hashCode == HASH_CODE_CHAR && "C".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java.lang.Character", methodName, "(C)Ljava/lang/Character;", false);
        } else if (hashCode == HASH_CODE_SHORT && "S".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java/lang/Short", methodName, "(S)Ljava/lang/Short;", false);
        } else if (hashCode == HASH_CODE_DOUBLE && "D".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java/lang/Double", methodName, "(D)Ljava/lang/Double;", false);
        } else if (hashCode == HASH_CODE_FLOAT && "F".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java/lang/Float", methodName, "(F)Ljava/lang/Float;", false);
        } else if (hashCode == HASH_CODE_LONG && "J".equals(returnTypeDesc)) {
            mv.visitMethodInsn(opcode, "java/lang/Long", methodName, "(J)Ljava/lang/Long;", false);
        }
    }
}

