/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import java.io.Serializable;
import java.util.Map;

public class PdfDocumentInfo
implements Serializable {
    static final PdfName[] PDF20_DEPRECATED_KEYS = new PdfName[]{PdfName.Title, PdfName.Author, PdfName.Subject, PdfName.Keywords, PdfName.Creator, PdfName.Producer, PdfName.Trapped};
    private static final long serialVersionUID = -21957940280527125L;
    private PdfDictionary infoDictionary;

    PdfDocumentInfo(PdfDictionary pdfObject, PdfDocument pdfDocument) {
        this.infoDictionary = pdfObject;
        if (pdfDocument.getWriter() != null) {
            this.infoDictionary.makeIndirect(pdfDocument);
        }
    }

    PdfDocumentInfo(PdfDocument pdfDocument) {
        this(new PdfDictionary(), pdfDocument);
    }

    public PdfDocumentInfo setTitle(String title) {
        return this.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
    }

    public PdfDocumentInfo setAuthor(String author) {
        return this.put(PdfName.Author, new PdfString(author, "UnicodeBig"));
    }

    public PdfDocumentInfo setSubject(String subject) {
        return this.put(PdfName.Subject, new PdfString(subject, "UnicodeBig"));
    }

    public PdfDocumentInfo setKeywords(String keywords) {
        return this.put(PdfName.Keywords, new PdfString(keywords, "UnicodeBig"));
    }

    public PdfDocumentInfo setCreator(String creator) {
        return this.put(PdfName.Creator, new PdfString(creator, "UnicodeBig"));
    }

    public PdfDocumentInfo setTrapped(PdfName trapped) {
        return this.put(PdfName.Trapped, trapped);
    }

    public String getTitle() {
        return this.getStringValue(PdfName.Title);
    }

    public String getAuthor() {
        return this.getStringValue(PdfName.Author);
    }

    public String getSubject() {
        return this.getStringValue(PdfName.Subject);
    }

    public String getKeywords() {
        return this.getStringValue(PdfName.Keywords);
    }

    public String getCreator() {
        return this.getStringValue(PdfName.Creator);
    }

    public String getProducer() {
        return this.getStringValue(PdfName.Producer);
    }

    public PdfName getTrapped() {
        return this.infoDictionary.getAsName(PdfName.Trapped);
    }

    public PdfDocumentInfo addCreationDate() {
        return this.put(PdfName.CreationDate, (PdfObject)new PdfDate().getPdfObject());
    }

    public PdfDocumentInfo addModDate() {
        return this.put(PdfName.ModDate, (PdfObject)new PdfDate().getPdfObject());
    }

    public void setMoreInfo(Map<String, String> moreInfo) {
        if (moreInfo != null) {
            for (Map.Entry<String, String> entry : moreInfo.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.setMoreInfo(key, value);
            }
        }
    }

    public void setMoreInfo(String key, String value) {
        PdfName keyName = new PdfName(key);
        if (value == null) {
            this.infoDictionary.remove(keyName);
            this.infoDictionary.setModified();
        } else {
            this.put(keyName, new PdfString(value, "UnicodeBig"));
        }
    }

    public String getMoreInfo(String key) {
        return this.getStringValue(new PdfName(key));
    }

    PdfDictionary getPdfObject() {
        return this.infoDictionary;
    }

    PdfDocumentInfo put(PdfName key, PdfObject value) {
        this.getPdfObject().put(key, value);
        this.getPdfObject().setModified();
        return this;
    }

    private String getStringValue(PdfName name) {
        PdfString pdfString = this.infoDictionary.getAsString(name);
        return pdfString != null ? pdfString.toUnicodeString() : null;
    }
}

