/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.zuul.filters.pre.ratelimit;

import com.marcosbarbero.zuul.filters.pre.ratelimit.config.Policy;
import com.marcosbarbero.zuul.filters.pre.ratelimit.config.Rate;
import com.marcosbarbero.zuul.filters.pre.ratelimit.config.RateLimitProperties;
import com.marcosbarbero.zuul.filters.pre.ratelimit.config.RateLimiter;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.UrlPathHelper;

public class RateLimitFilter
extends ZuulFilter {
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();
    private static final String X_FORWARDED_FOR = "X-FORWARDED-FOR";
    private static final String ANONYMOUS = "anonymous";
    private final RateLimiter limiter;
    private final RateLimitProperties properties;
    private final RouteLocator routeLocator;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -1;
    }

    public boolean shouldFilter() {
        return this.properties.isEnabled() && this.policy() != null;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletResponse response = ctx.getResponse();
        HttpServletRequest request = ctx.getRequest();
        Optional.ofNullable(this.policy()).ifPresent(policy -> {
            Rate rate = this.limiter.consume((Policy)policy, this.key(request, policy.getType()));
            response.setHeader("X-RateLimit-Limit", rate.getLimit().toString());
            response.setHeader("X-RateLimit-Remaining", String.valueOf(Math.max(rate.getRemaining(), 0L)));
            response.setHeader("X-RateLimit-Reset", rate.getReset().toString());
            if (rate.getRemaining() < 0L) {
                ctx.setResponseStatusCode(HttpStatus.TOO_MANY_REQUESTS.value());
                ctx.put((Object)"rateLimitExceeded", (Object)"true");
                throw new RuntimeException(HttpStatus.TOO_MANY_REQUESTS.toString());
            }
        });
        return null;
    }

    private String requestURI() {
        return URL_PATH_HELPER.getPathWithinApplication(RequestContext.getCurrentContext().getRequest());
    }

    private Route route() {
        return this.routeLocator.getMatchingRoute(this.requestURI());
    }

    private Policy policy() {
        return this.route() != null ? this.properties.getPolicies().get(this.route().getId()) : null;
    }

    private String key(HttpServletRequest request, List<Policy.Type> types) {
        Route route = this.route();
        StringBuilder builder = new StringBuilder(route.getId());
        if (types.contains((Object)Policy.Type.URL)) {
            builder.append(":").append(route.getPath());
        }
        if (types.contains((Object)Policy.Type.ORIGIN)) {
            builder.append(":").append(this.getRemoteAddr(request));
        }
        if (types.contains((Object)Policy.Type.USER)) {
            builder.append(":").append(request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : ANONYMOUS);
        }
        return builder.toString();
    }

    private String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = this.properties.isBehindProxy() && request.getHeader(X_FORWARDED_FOR) != null ? request.getHeader(X_FORWARDED_FOR) : request.getRemoteAddr();
        return remoteAddr;
    }

    @ConstructorProperties(value={"limiter", "properties", "routeLocator"})
    public RateLimitFilter(RateLimiter limiter, RateLimitProperties properties, RouteLocator routeLocator) {
        this.limiter = limiter;
        this.properties = properties;
        this.routeLocator = routeLocator;
    }

    static interface Headers {
        public static final String LIMIT = "X-RateLimit-Limit";
        public static final String REMAINING = "X-RateLimit-Remaining";
        public static final String RESET = "X-RateLimit-Reset";
    }
}

