/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.salt;

import java.io.UnsupportedEncodingException;
import org.jasypt.commons.CommonUtils;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.salt.IVGenerator;

public class StringFixedIVGenerator
implements IVGenerator {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final String iv;
    private final String charset;
    private final byte[] ivBytes;

    public StringFixedIVGenerator(String iv) {
        this(iv, null);
    }

    public StringFixedIVGenerator(String iv, String charset) {
        CommonUtils.validateNotNull(iv, "IV cannot be set null");
        this.iv = iv;
        this.charset = charset != null ? charset : DEFAULT_CHARSET;
        try {
            this.ivBytes = this.iv.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionInitializationException("Invalid charset specified: " + this.charset);
        }
    }

    @Override
    public byte[] generateIV(int lengthBytes) {
        if (this.ivBytes.length < lengthBytes) {
            throw new EncryptionInitializationException("Requested IV larger than set");
        }
        byte[] generatedIV = new byte[lengthBytes];
        System.arraycopy(this.ivBytes, 0, generatedIV, 0, lengthBytes);
        return generatedIV;
    }

    @Override
    public boolean includePlainIVInEncryptionResults() {
        return false;
    }
}

