/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.AbstractParameterResultSetHandler;
import com.mockrunner.jdbc.ParameterWrapper;
import com.mockrunner.mock.jdbc.MockParameterMap;
import com.mockrunner.util.regexp.PatternMatcher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutParameterResultSetHandler
extends AbstractParameterResultSetHandler {
    private boolean mustRegisterOutParameters = false;
    private MockParameterMap globalOutParameter = null;
    private final Map<String, MockParameterMap> outParameterForStatement = new TreeMap<String, MockParameterMap>();
    private final Map<PatternMatcher, MockParameterMap> outParameterForStatementCompiled = new TreeMap<PatternMatcher, MockParameterMap>();
    private final Map<String, List<ParameterWrapper<MockParameterMap>>> outParameterForStatementParameters = new TreeMap<String, List<ParameterWrapper<MockParameterMap>>>();
    private final Map<PatternMatcher, List<ParameterWrapper<MockParameterMap>>> outParameterForStatementParametersCompiled = new HashMap<PatternMatcher, List<ParameterWrapper<MockParameterMap>>>();

    @Override
    protected void onPatternMatcherFactoryChanged() {
        super.onPatternMatcherFactoryChanged();
        this.recompile(this.outParameterForStatement, this.outParameterForStatementCompiled);
        this.recompile(this.outParameterForStatementParameters, this.outParameterForStatementParametersCompiled);
    }

    public void setMustRegisterOutParameters(boolean mustOutParameterBeRegistered) {
        this.mustRegisterOutParameters = mustOutParameterBeRegistered;
    }

    public boolean getMustRegisterOutParameters() {
        return this.mustRegisterOutParameters;
    }

    public MockParameterMap getOutParameter(String sql) {
        List<MockParameterMap> list = this.getMatchingObjects(this.outParameterForStatementCompiled, sql);
        if (null != list && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public MockParameterMap getOutParameter(String sql, MockParameterMap parameters) {
        ParameterWrapper wrapper = this.getMatchingParameterWrapper(sql, parameters, this.outParameterForStatementParametersCompiled, this.exactMatchParameter);
        if (null != wrapper) {
            return (MockParameterMap)wrapper.getWrappedObject();
        }
        return null;
    }

    public void clearOutParameter() {
        this.outParameterForStatement.clear();
        this.outParameterForStatementCompiled.clear();
        this.outParameterForStatementParameters.clear();
        this.outParameterForStatementParametersCompiled.clear();
    }

    public MockParameterMap getGlobalOutParameter() {
        return this.globalOutParameter;
    }

    public void prepareGlobalOutParameter(MockParameterMap outParameters) {
        this.globalOutParameter = new MockParameterMap(outParameters);
    }

    public void prepareOutParameter(String sql, MockParameterMap outParameters) {
        MockParameterMap mockParameterMap = new MockParameterMap(outParameters);
        this.outParameterForStatement.put(sql, mockParameterMap);
        this.outParameterForStatementCompiled.put(this.getPatternMatcherFactory().create(sql), mockParameterMap);
    }

    public void prepareOutParameter(String sql, MockParameterMap outParameters, Object[] parameters) {
        this.prepareOutParameter(sql, outParameters, Arrays.asList(parameters));
    }

    public void prepareOutParameter(String sql, MockParameterMap outParameters, List<Object> parameters) {
        MockParameterMap params = new MockParameterMap();
        for (int ii = 0; ii < parameters.size(); ++ii) {
            params.put(ii + 1, parameters.get(ii));
        }
        this.prepareOutParameter(sql, outParameters, params);
    }

    public void prepareOutParameter(String sql, MockParameterMap outParameters, MockParameterMap parameters) {
        List<ParameterWrapper<MockParameterMap>> list = this.getListFromMapForSQLStatement(sql, this.outParameterForStatementParameters);
        list.add(new ParameterWrapper<MockParameterMap>(new MockParameterMap(outParameters), new MockParameterMap(parameters)));
        this.outParameterForStatementParametersCompiled.put(this.getPatternMatcherFactory().create(sql), list);
    }

    public void removeOutParameter(String sql) {
        this.outParameterForStatement.remove(sql);
        this.outParameterForStatementCompiled.remove(this.getPatternMatcherFactory().create(sql));
    }

    public void removeOutParameter(String sql, MockParameterMap parameters) {
        this.removeMatchingParameterWrapper(sql, parameters, this.outParameterForStatementParameters, this.exactMatchParameter);
    }
}

