/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.emoji.internal;

import com.vladsch.flexmark.ext.emoji.Emoji;
import com.vladsch.flexmark.ext.emoji.EmojiImageType;
import com.vladsch.flexmark.ext.emoji.EmojiShortcutType;
import com.vladsch.flexmark.ext.emoji.internal.EmojiReference;
import com.vladsch.flexmark.ext.emoji.internal.EmojiShortcuts;

public class EmojiResolvedShortcut {
    public final EmojiReference.Emoji emoji;
    public final String emojiText;
    public final boolean isUnicode;
    public final String alt;

    public EmojiResolvedShortcut(EmojiReference.Emoji emoji, String emojiText, boolean isUnicode, String alt) {
        this.emoji = emoji;
        this.emojiText = emojiText;
        this.isUnicode = isUnicode;
        this.alt = alt;
    }

    public static EmojiResolvedShortcut getEmojiText(Emoji node, EmojiShortcutType useShortcutType, EmojiImageType useImageType, String rootImagePath) {
        return EmojiResolvedShortcut.getEmojiText(node.getText().toString(), useShortcutType, useImageType, rootImagePath);
    }

    public static EmojiResolvedShortcut getEmojiText(String emojiId, EmojiShortcutType useShortcutType, EmojiImageType useImageType, String rootImagePath) {
        EmojiReference.Emoji emoji = EmojiShortcuts.getEmojiFromShortcut(emojiId);
        String emojiText = null;
        boolean isUnicode = false;
        String alt = null;
        if (emoji != null) {
            String unicodeText = null;
            String imageText = null;
            if (useImageType.isUnicode && emoji.unicodeChars != null) {
                unicodeText = EmojiShortcuts.getUnicodeChars(emoji);
            }
            if (useImageType.isImage) {
                String gitHubFile = null;
                String cheatSheetFile = null;
                if (useShortcutType.isGitHub && emoji.githubFile != null) {
                    gitHubFile = "https://assets-cdn.github.com/images/icons/emoji/" + emoji.githubFile;
                }
                if (useShortcutType.isEmojiCheatSheet && emoji.emojiCheatSheetFile != null) {
                    cheatSheetFile = rootImagePath + emoji.emojiCheatSheetFile;
                }
                imageText = useShortcutType.getPreferred(cheatSheetFile, gitHubFile);
            }
            if (imageText != null) {
                if (unicodeText != null) {
                    emojiText = unicodeText;
                    isUnicode = true;
                } else {
                    emojiText = imageText;
                }
                alt = "emoji " + emoji.category + ":" + emoji.shortcut;
            }
        }
        return new EmojiResolvedShortcut(emoji, emojiText, isUnicode, alt);
    }
}

