/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.superscript.internal;

import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.superscript.Superscript;
import com.vladsch.flexmark.superscript.SuperscriptExtension;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class SuperscriptNodeRenderer
implements NodeRenderer {
    private final String superscriptStyleHtmlOpen;
    private final String superscriptStyleHtmlClose;

    public SuperscriptNodeRenderer(DataHolder options) {
        this.superscriptStyleHtmlOpen = (String)SuperscriptExtension.SUPERSCRIPT_STYLE_HTML_OPEN.getFrom(options);
        this.superscriptStyleHtmlClose = (String)SuperscriptExtension.SUPERSCRIPT_STYLE_HTML_CLOSE.getFrom(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Superscript.class, (CustomNodeRenderer)new CustomNodeRenderer<Superscript>(){

            public void render(Superscript node, NodeRendererContext context, HtmlWriter html) {
                SuperscriptNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Superscript node, NodeRendererContext context, HtmlWriter html) {
        if (this.superscriptStyleHtmlOpen == null || this.superscriptStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag((CharSequence)"sup");
            } else {
                html.srcPos(node.getText()).withAttr().tag((CharSequence)"sup");
            }
            context.renderChildren((Node)node);
            html.tag((CharSequence)"/sup");
        } else {
            html.raw((CharSequence)this.superscriptStyleHtmlOpen);
            context.renderChildren((Node)node);
            html.raw((CharSequence)this.superscriptStyleHtmlClose);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer apply(DataHolder options) {
            return new SuperscriptNodeRenderer(options);
        }
    }
}

