/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlankLine;
import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.DelimitedLinkNode;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.formatter.TranslationPlaceholderGenerator;
import com.vladsch.flexmark.formatter.internal.FormatterOptions;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.internal.NodeRepositoryFormatter;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.Consumer;
import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CoreNodeFormatter
extends NodeRepositoryFormatter<ReferenceRepository, Reference, RefNode> {
    public static final DataKey<Integer> LIST_ITEM_NUMBER = new DataKey("LIST_ITEM_NUMBER", (Object)0);
    public static final DataKey<ListSpacing> LIST_ITEM_SPACING = new DataKey("LIST_ITEM_SPACING", (Object)null);
    private final FormatterOptions formatterOptions;
    private final ListOptions listOptions;
    private final String myHtmlBlockPrefix;
    private int blankLines;
    MutableDataHolder myTranslationStore;
    static final TranslationPlaceholderGenerator htmlEntityPlaceholderGenerator = new TranslationPlaceholderGenerator(){

        @Override
        public String getPlaceholder(int index) {
            return String.format("&#%d;", index);
        }
    };
    public static final DataKey<Boolean> UNWRAPPED_AUTO_LINKS = new DataKey("UNWRAPPED_AUTO_LINKS", (Object)false);
    public static final DataKey<HashSet<String>> UNWRAPPED_AUTO_LINKS_MAP = new DataKey("UNWRAPPED_AUTO_LINKS_MAP", new HashSet());

    public CoreNodeFormatter(DataHolder options) {
        super(options, null);
        this.formatterOptions = new FormatterOptions(options);
        this.listOptions = ListOptions.getFrom((DataHolder)options);
        this.blankLines = 0;
        this.myHtmlBlockPrefix = "<" + this.formatterOptions.translationHtmlBlockPrefix;
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        if (this.formatterOptions.referencePlacement != ElementPlacement.AS_IS && this.formatterOptions.referenceSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(RefNode.class));
    }

    @Override
    public ReferenceRepository getRepository(DataHolder options) {
        return (ReferenceRepository)options.get(Parser.REFERENCES);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.formatterOptions.referencePlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.formatterOptions.referenceSort;
    }

    @Override
    public void renderReferenceBlock(Reference node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            markdown.append((CharSequence)node.getOpeningMarker());
            markdown.appendTranslating((CharSequence)node.getReference());
            markdown.append((CharSequence)node.getClosingMarker());
            markdown.append(' ');
            markdown.append((CharSequence)node.getUrlOpeningMarker());
            markdown.appendNonTranslating((CharSequence)node.getPageRef());
            markdown.append((CharSequence)node.getAnchorMarker());
            if (node.getAnchorRef().isNotNull()) {
                CharSequence anchorRef = context.transformAnchorRef((CharSequence)node.getPageRef(), (CharSequence)node.getAnchorRef());
                markdown.append(anchorRef);
            }
            markdown.append((CharSequence)node.getUrlClosingMarker());
            if (node.getTitleOpeningMarker().isNotNull()) {
                markdown.append(' ');
                markdown.append((CharSequence)node.getTitleOpeningMarker());
                if (node.getTitle().isNotNull()) {
                    markdown.appendTranslating((CharSequence)node.getTitle());
                }
                markdown.append((CharSequence)node.getTitleClosingMarker());
            }
            markdown.append((CharSequence)node.getUrlClosingMarker()).line();
        } else {
            markdown.append((CharSequence)node.getChars()).line();
        }
    }

    @Override
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<Node>(Node.class, new CustomNodeFormatter<Node>(){

            @Override
            public void render(Node node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<AutoLink>(AutoLink.class, new CustomNodeFormatter<AutoLink>(){

            @Override
            public void render(AutoLink node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<BlankLine>(BlankLine.class, new CustomNodeFormatter<BlankLine>(){

            @Override
            public void render(BlankLine node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<BlockQuote>(BlockQuote.class, new CustomNodeFormatter<BlockQuote>(){

            @Override
            public void render(BlockQuote node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Code>(Code.class, new CustomNodeFormatter<Code>(){

            @Override
            public void render(Code node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Document>(Document.class, new CustomNodeFormatter<Document>(){

            @Override
            public void render(Document node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Emphasis>(Emphasis.class, new CustomNodeFormatter<Emphasis>(){

            @Override
            public void render(Emphasis node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<FencedCodeBlock>(FencedCodeBlock.class, new CustomNodeFormatter<FencedCodeBlock>(){

            @Override
            public void render(FencedCodeBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HardLineBreak>(HardLineBreak.class, new CustomNodeFormatter<HardLineBreak>(){

            @Override
            public void render(HardLineBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Heading>(Heading.class, new CustomNodeFormatter<Heading>(){

            @Override
            public void render(Heading node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HtmlBlock>(HtmlBlock.class, new CustomNodeFormatter<HtmlBlock>(){

            @Override
            public void render(HtmlBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HtmlCommentBlock>(HtmlCommentBlock.class, new CustomNodeFormatter<HtmlCommentBlock>(){

            @Override
            public void render(HtmlCommentBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HtmlInnerBlock>(HtmlInnerBlock.class, new CustomNodeFormatter<HtmlInnerBlock>(){

            @Override
            public void render(HtmlInnerBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, new CustomNodeFormatter<HtmlInnerBlockComment>(){

            @Override
            public void render(HtmlInnerBlockComment node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HtmlEntity>(HtmlEntity.class, new CustomNodeFormatter<HtmlEntity>(){

            @Override
            public void render(HtmlEntity node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HtmlInline>(HtmlInline.class, new CustomNodeFormatter<HtmlInline>(){

            @Override
            public void render(HtmlInline node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<HtmlInlineComment>(HtmlInlineComment.class, new CustomNodeFormatter<HtmlInlineComment>(){

            @Override
            public void render(HtmlInlineComment node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Image>(Image.class, new CustomNodeFormatter<Image>(){

            @Override
            public void render(Image node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<ImageRef>(ImageRef.class, new CustomNodeFormatter<ImageRef>(){

            @Override
            public void render(ImageRef node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<IndentedCodeBlock>(IndentedCodeBlock.class, new CustomNodeFormatter<IndentedCodeBlock>(){

            @Override
            public void render(IndentedCodeBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Link>(Link.class, new CustomNodeFormatter<Link>(){

            @Override
            public void render(Link node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<LinkRef>(LinkRef.class, new CustomNodeFormatter<LinkRef>(){

            @Override
            public void render(LinkRef node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<BulletList>(BulletList.class, new CustomNodeFormatter<BulletList>(){

            @Override
            public void render(BulletList node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<OrderedList>(OrderedList.class, new CustomNodeFormatter<OrderedList>(){

            @Override
            public void render(OrderedList node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<BulletListItem>(BulletListItem.class, new CustomNodeFormatter<BulletListItem>(){

            @Override
            public void render(BulletListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<OrderedListItem>(OrderedListItem.class, new CustomNodeFormatter<OrderedListItem>(){

            @Override
            public void render(OrderedListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<MailLink>(MailLink.class, new CustomNodeFormatter<MailLink>(){

            @Override
            public void render(MailLink node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Paragraph>(Paragraph.class, new CustomNodeFormatter<Paragraph>(){

            @Override
            public void render(Paragraph node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Reference>(Reference.class, new CustomNodeFormatter<Reference>(){

            @Override
            public void render(Reference node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<SoftLineBreak>(SoftLineBreak.class, new CustomNodeFormatter<SoftLineBreak>(){

            @Override
            public void render(SoftLineBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<StrongEmphasis>(StrongEmphasis.class, new CustomNodeFormatter<StrongEmphasis>(){

            @Override
            public void render(StrongEmphasis node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<Text>(Text.class, new CustomNodeFormatter<Text>(){

            @Override
            public void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<TextBase>(TextBase.class, new CustomNodeFormatter<TextBase>(){

            @Override
            public void render(TextBase node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<ThematicBreak>(ThematicBreak.class, new CustomNodeFormatter<ThematicBreak>(){

            @Override
            public void render(ThematicBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
                CoreNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    private void render(Node node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence chars = node.getChars();
        if (node instanceof Block) {
            BasedSequence suffix;
            BasedSequence prefix;
            BasedSequence contentChars = ((Block)node).getContentChars();
            if (chars.isNotNull() && !(prefix = chars.prefixOf(contentChars)).isEmpty()) {
                markdown.append((CharSequence)prefix);
            }
            context.renderChildren(node);
            if (chars.isNotNull() && !(suffix = chars.suffixOf(contentChars)).isEmpty()) {
                markdown.append((CharSequence)suffix);
            }
        } else {
            markdown.append((CharSequence)chars);
        }
    }

    private void render(BlankLine node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getDocument().get(LIST_ITEM_SPACING) == null) {
            if (node.getPrevious() != null && !(node.getPrevious() instanceof BlankLine)) {
                this.blankLines = 0;
            }
            ++this.blankLines;
            if (this.blankLines <= this.formatterOptions.maxBlankLines) {
                markdown.blankLine(this.blankLines);
            }
        }
    }

    private void render(Document node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTranslationStore = context.getTranslationStore();
        context.renderChildren((Node)node);
    }

    /*
     * Unable to fully structure code
     */
    private void render(final Heading node, NodeFormatterContext context, MarkdownWriter markdown) {
        block13: {
            block12: {
                markdown.blankLine();
                if (!node.isAtxHeading()) break block12;
                markdown.append((CharSequence)node.getOpeningMarker());
                v0 = spaceAfterAtx = this.formatterOptions.spaceAfterAtxMarker == DiscretionaryText.ADD || this.formatterOptions.spaceAfterAtxMarker == DiscretionaryText.AS_IS && node.getOpeningMarker().getEndOffset() < node.getText().getStartOffset();
                if (spaceAfterAtx) {
                    markdown.append(' ');
                }
                context.translatingRefTargetSpan((Node)node, new TranslatingSpanRender(){

                    @Override
                    public void render(NodeFormatterContext context, MarkdownWriter writer) {
                        context.renderChildren((Node)node);
                    }
                });
                switch (41.$SwitchMap$com$vladsch$flexmark$util$format$options$EqualizeTrailingMarker[this.formatterOptions.atxHeaderTrailingMarker.ordinal()]) {
                    case 1: {
                        if (node.getOpeningMarker().isNull()) ** break;
                    }
                    case 2: {
                        if (spaceAfterAtx) {
                            markdown.append(' ');
                        }
                        markdown.append((CharSequence)node.getOpeningMarker());
                        ** break;
                    }
                    case 3: {
                        ** break;
                    }
                    default: {
                        if (node.getClosingMarker().isNotNull()) {
                            if (spaceAfterAtx) {
                                markdown.append(' ');
                            }
                            markdown.append((CharSequence)node.getClosingMarker());
                        }
lbl31:
                        // 6 sources

                        break block13;
                    }
                }
            }
            ref = new Ref((Object)markdown.offset());
            markdown.lastOffset(ref);
            context.translatingRefTargetSpan((Node)node, new TranslatingSpanRender(){

                @Override
                public void render(NodeFormatterContext context, MarkdownWriter writer) {
                    context.renderChildren((Node)node);
                }
            });
            markdown.line();
            if (this.formatterOptions.setextHeaderEqualizeMarker) {
                markdown.repeat(node.getClosingMarker().charAt(0), Utils.minLimit((int)(markdown.offset() - (Integer)ref.value), (int[])new int[]{this.formatterOptions.minSetextMarkerLength}));
            } else {
                markdown.append((CharSequence)node.getClosingMarker());
            }
        }
        markdown.tailBlankLine();
    }

    private void render(BlockQuote node, NodeFormatterContext context, MarkdownWriter markdown) {
        String prefix = node.getOpeningMarker().toString();
        boolean compactPrefix = false;
        switch (this.formatterOptions.blockQuoteMarkers) {
            case AS_IS: {
                prefix = node.getChars().baseSubSequence(node.getOpeningMarker().getStartOffset(), node.getFirstChild().getStartOffset()).toString();
                break;
            }
            case ADD_COMPACT: {
                prefix = ">";
                break;
            }
            case ADD_COMPACT_WITH_SPACE: {
                prefix = "> ";
                compactPrefix = true;
                break;
            }
            case ADD_SPACED: {
                prefix = "> ";
            }
        }
        if (this.formatterOptions.blockQuoteBlankLines) {
            markdown.blankLine();
        }
        markdown.pushPrefix();
        String combinedPrefix = markdown.getPrefix().toString();
        combinedPrefix = compactPrefix && combinedPrefix.endsWith("> ") ? combinedPrefix.substring(0, combinedPrefix.length() - 1) + prefix : combinedPrefix + prefix;
        int markdownOptions = markdown.getOptions();
        markdown.setOptions(markdownOptions | 8);
        markdown.setPrefix(combinedPrefix);
        markdown.setOptions(markdownOptions);
        context.renderChildren((Node)node);
        markdown.popPrefix();
        if (this.formatterOptions.blockQuoteBlankLines) {
            markdown.blankLine();
        }
    }

    private void render(ThematicBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        if (this.formatterOptions.thematicBreak != null) {
            markdown.append(this.formatterOptions.thematicBreak);
        } else {
            markdown.append((CharSequence)node.getChars());
        }
        markdown.tailBlankLine();
    }

    private void render(FencedCodeBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        BasedSequence openingMarker = node.getOpeningMarker();
        Object closingMarker = node.getClosingMarker();
        char openingMarkerChar = openingMarker.charAt(0);
        char closingMarkerChar = closingMarker.length() > 0 ? closingMarker.charAt(0) : (char)'\u0000';
        int openingMarkerLen = openingMarker.length();
        int closingMarkerLen = closingMarker.length();
        switch (this.formatterOptions.fencedCodeMarkerType) {
            case ANY: {
                break;
            }
            case BACK_TICK: {
                closingMarkerChar = openingMarkerChar = '`';
                break;
            }
            case TILDE: {
                closingMarkerChar = openingMarkerChar = '~';
            }
        }
        if (openingMarkerLen < this.formatterOptions.fencedCodeMarkerLength) {
            openingMarkerLen = this.formatterOptions.fencedCodeMarkerLength;
        }
        if (closingMarkerLen < this.formatterOptions.fencedCodeMarkerLength) {
            closingMarkerLen = this.formatterOptions.fencedCodeMarkerLength;
        }
        openingMarker = RepeatedCharSequence.of((CharSequence)String.valueOf(openingMarkerChar), (int)openingMarkerLen);
        closingMarker = this.formatterOptions.fencedCodeMatchClosingMarker || closingMarkerChar == '\u0000' ? openingMarker : RepeatedCharSequence.of((CharSequence)String.valueOf(closingMarkerChar), (int)closingMarkerLen);
        markdown.append((CharSequence)openingMarker);
        if (this.formatterOptions.fencedCodeSpaceBeforeInfo) {
            markdown.append(' ');
        }
        markdown.appendNonTranslating((CharSequence)node.getInfo());
        markdown.line();
        markdown.openPreFormatted(true);
        if (context.isTransformingText()) {
            markdown.appendNonTranslating((CharSequence)node.getContentChars());
        } else if (this.formatterOptions.fencedCodeMinimizeIndent) {
            List lines = node.getContentLines();
            int[] leadColumns = new int[lines.size()];
            int minSpaces = Integer.MAX_VALUE;
            int i = 0;
            for (BasedSequence line : lines) {
                leadColumns[i] = line.countLeadingColumns(0, (CharSequence)" \t");
                minSpaces = Utils.min((int)minSpaces, (int[])new int[]{leadColumns[i]});
                ++i;
            }
            ArrayList trimmedLines = new ArrayList();
            if (minSpaces > 0) {
                i = 0;
                for (BasedSequence line : lines) {
                    if (leadColumns[i] > minSpaces) {
                        markdown.repeat(' ', leadColumns[i] - minSpaces);
                    }
                    markdown.append((CharSequence)line.trimStart());
                    ++i;
                }
            } else {
                markdown.append((CharSequence)node.getContentChars());
            }
        } else {
            markdown.append((CharSequence)node.getContentChars());
        }
        markdown.closePreFormatted();
        markdown.line().append((CharSequence)closingMarker).line();
        markdown.tailBlankLine();
    }

    private void render(IndentedCodeBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        String prefix = RepeatedCharSequence.of((CharSequence)" ", (int)this.listOptions.getCodeIndent()).toString();
        if (this.formatterOptions.emulationProfile == ParserEmulationProfile.GITHUB_DOC && node.getParent() instanceof ListItem) {
            BasedSequence marker = ((ListItem)node.getParent()).getOpeningMarker();
            prefix = RepeatedCharSequence.of((CharSequence)" ", (int)Utils.minLimit((int)(8 - marker.length() - 1), (int[])new int[]{4})).toString();
        }
        markdown.pushPrefix().addPrefix(prefix);
        markdown.openPreFormatted(true);
        if (context.isTransformingText()) {
            markdown.appendNonTranslating((CharSequence)node.getContentChars());
        } else if (this.formatterOptions.indentedCodeMinimizeIndent) {
            List lines = node.getContentLines();
            int[] leadColumns = new int[lines.size()];
            int minSpaces = Integer.MAX_VALUE;
            int i = 0;
            for (BasedSequence line : lines) {
                leadColumns[i] = line.countLeadingColumns(0, (CharSequence)" \t");
                minSpaces = Utils.min((int)minSpaces, (int[])new int[]{leadColumns[i]});
                ++i;
            }
            if (minSpaces > 0) {
                i = 0;
                for (BasedSequence line : lines) {
                    if (leadColumns[i] > minSpaces) {
                        markdown.repeat(' ', leadColumns[i] - minSpaces);
                    }
                    markdown.append((CharSequence)line.trimStart());
                    ++i;
                }
            } else {
                markdown.append((CharSequence)node.getContentChars());
            }
        } else {
            markdown.append((CharSequence)node.getContentChars());
        }
        markdown.closePreFormatted();
        markdown.popPrefix();
        markdown.tailBlankLine();
    }

    private void render(BulletList node, NodeFormatterContext context, MarkdownWriter markdown) {
        CoreNodeFormatter.renderList((ListBlock)node, context, markdown);
    }

    private void render(OrderedList node, NodeFormatterContext context, MarkdownWriter markdown) {
        CoreNodeFormatter.renderList((ListBlock)node, context, markdown);
    }

    private void render(BulletListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        CoreNodeFormatter.renderListItem((ListItem)node, context, markdown, this.listOptions, "", false);
    }

    private void render(OrderedListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        CoreNodeFormatter.renderListItem((ListItem)node, context, markdown, this.listOptions, "", false);
    }

    public static void renderList(ListBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        ArrayList<Node> itemList = new ArrayList<Node>();
        for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
            itemList.add(item);
        }
        CoreNodeFormatter.renderList(node, context, markdown, itemList);
    }

    public static void renderList(ListBlock node, NodeFormatterContext context, MarkdownWriter markdown, List<Node> itemList) {
        if (context.getFormatterOptions().listAddBlankLineBefore && !node.isOrDescendantOfType(new Class[]{ListItem.class})) {
            markdown.blankLine();
        }
        Document document = context.getDocument();
        ListSpacing listSpacing = (ListSpacing)document.get(LIST_ITEM_SPACING);
        int listItemNumber = (Integer)document.get(LIST_ITEM_NUMBER);
        document.set(LIST_ITEM_NUMBER, (Object)(node instanceof OrderedList ? ((OrderedList)node).getStartNumber() : 1));
        ListSpacing itemSpacing = null;
        block0 : switch (context.getFormatterOptions().listSpacing) {
            case AS_IS: {
                break;
            }
            case LOOSE: {
                itemSpacing = ListSpacing.LOOSE;
                break;
            }
            case TIGHT: {
                itemSpacing = ListSpacing.TIGHT;
                break;
            }
            case LOOSEN: {
                itemSpacing = node.isLoose() ? ListSpacing.LOOSE : ListSpacing.TIGHT;
                break;
            }
            case TIGHTEN: {
                itemSpacing = ListSpacing.LOOSE;
                for (Node item : itemList) {
                    if (!(item instanceof ListItem) || !((ListItem)item).isOwnTight() || item.getNext() == null) continue;
                    itemSpacing = ListSpacing.TIGHT;
                    break block0;
                }
                break;
            }
        }
        document.set(LIST_ITEM_SPACING, (Object)(itemSpacing == ListSpacing.LOOSE && (listSpacing == null || listSpacing == ListSpacing.LOOSE) ? ListSpacing.LOOSE : itemSpacing));
        for (Node item : itemList) {
            if (itemSpacing == ListSpacing.LOOSE && (listSpacing == null || listSpacing == ListSpacing.LOOSE)) {
                markdown.blankLine();
            }
            context.render(item);
        }
        document.set(LIST_ITEM_SPACING, (Object)listSpacing);
        document.set(LIST_ITEM_NUMBER, (Object)listItemNumber);
        if (!node.isOrDescendantOfType(new Class[]{ListItem.class})) {
            markdown.blankLine();
        }
    }

    public static void renderListItem(ListItem node, NodeFormatterContext context, MarkdownWriter markdown, ListOptions listOptions, CharSequence markerSuffix, boolean addBlankLineLooseItems) {
        FormatterOptions options = context.getFormatterOptions();
        if (options.listRemoveEmptyItems && (!node.hasChildren() || node.getFirstChildAnyNot(new Class[]{BlankLine.class}) == null)) {
            return;
        }
        Object openingMarker = node.getOpeningMarker();
        if (node instanceof OrderedListItem) {
            char delimiter = openingMarker.charAt(openingMarker.length() - 1);
            CharSequence number = openingMarker.subSequence(0, openingMarker.length() - 1);
            switch (options.listNumberedMarker) {
                case ANY: {
                    break;
                }
                case DOT: {
                    delimiter = '.';
                    break;
                }
                case PAREN: {
                    delimiter = ')';
                    break;
                }
                default: {
                    throw new IllegalStateException("Missing case for ListNumberedMarker " + options.listNumberedMarker.name());
                }
            }
            if (options.listRenumberItems) {
                Document document = context.getDocument();
                Integer itemNumber = (Integer)document.get(LIST_ITEM_NUMBER);
                Object[] objectArray = new Object[2];
                Integer n = itemNumber;
                Integer n2 = itemNumber = Integer.valueOf(itemNumber + 1);
                objectArray[0] = n;
                objectArray[1] = Character.valueOf(delimiter);
                openingMarker = String.format("%d%c", objectArray);
                document.set(LIST_ITEM_NUMBER, (Object)itemNumber);
            } else {
                openingMarker = String.format("%s%c", number, Character.valueOf(delimiter));
            }
        } else {
            switch (options.listBulletMarker) {
                case ANY: {
                    break;
                }
                case DASH: {
                    openingMarker = "-";
                    break;
                }
                case ASTERISK: {
                    openingMarker = "*";
                    break;
                }
                case PLUS: {
                    openingMarker = "+";
                    break;
                }
                default: {
                    throw new IllegalStateException("Missing case for ListBulletMarker " + options.listBulletMarker.name());
                }
            }
        }
        markdown.append((CharSequence)openingMarker).append(' ').append(markerSuffix);
        markdown.pushPrefix().addPrefix((CharSequence)(options.itemContentIndent ? RepeatedCharSequence.of((char)' ', (int)(openingMarker.length() + (listOptions.isItemContentAfterSuffix() ? markerSuffix.length() : 0) + 1)) : RepeatedCharSequence.of((CharSequence)" ", (int)listOptions.getItemIndent()).toString()));
        if (node.hasChildren() && node.getFirstChildAnyNot(new Class[]{BlankLine.class}) != null) {
            context.renderChildren((Node)node);
            if (addBlankLineLooseItems && (node.isLoose() || node.getDocument().get(LIST_ITEM_SPACING) == ListSpacing.LOOSE)) {
                markdown.blankLine();
            }
        } else if (node.isLoose()) {
            markdown.blankLine();
        } else {
            markdown.addLine();
        }
        markdown.popPrefix();
    }

    private void render(Emphasis node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getOpeningMarker());
        context.renderChildren((Node)node);
        markdown.append((CharSequence)node.getOpeningMarker());
    }

    private void render(StrongEmphasis node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getOpeningMarker());
        context.renderChildren((Node)node);
        markdown.append((CharSequence)node.getOpeningMarker());
    }

    public static void renderTextBlockParagraphLines(final Node node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.translatingSpan(new TranslatingSpanRender(){

            @Override
            public void render(NodeFormatterContext context, MarkdownWriter writer) {
                context.renderChildren(node);
            }
        });
        markdown.line();
    }

    public static void renderLooseParagraph(Paragraph node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        CoreNodeFormatter.renderTextBlockParagraphLines((Node)node, context, markdown);
        markdown.tailBlankLine();
    }

    public static void renderLooseItemParagraph(Paragraph node, NodeFormatterContext context, MarkdownWriter markdown) {
        CoreNodeFormatter.renderTextBlockParagraphLines((Node)node, context, markdown);
        markdown.tailBlankLine();
    }

    private void render(Paragraph node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!(node.getParent() instanceof ParagraphItemContainer)) {
            if (!node.isTrailingBlankLine() && (node.getNext() == null || node.getNext() instanceof ListBlock)) {
                CoreNodeFormatter.renderTextBlockParagraphLines((Node)node, context, markdown);
            } else {
                CoreNodeFormatter.renderLooseParagraph(node, context, markdown);
            }
        } else {
            boolean isItemParagraph = ((ParagraphItemContainer)node.getParent()).isItemParagraph(node);
            if (isItemParagraph) {
                ListSpacing itemSpacing = (ListSpacing)context.getDocument().get(LIST_ITEM_SPACING);
                if (itemSpacing == ListSpacing.TIGHT) {
                    CoreNodeFormatter.renderTextBlockParagraphLines((Node)node, context, markdown);
                } else if (itemSpacing == ListSpacing.LOOSE) {
                    if (node.getParent().getNextAnyNot(new Class[]{BlankLine.class}) == null) {
                        CoreNodeFormatter.renderTextBlockParagraphLines((Node)node, context, markdown);
                    } else {
                        CoreNodeFormatter.renderLooseItemParagraph(node, context, markdown);
                    }
                } else if (!((ParagraphItemContainer)node.getParent()).isParagraphWrappingDisabled(node, this.listOptions, context.getOptions())) {
                    CoreNodeFormatter.renderLooseItemParagraph(node, context, markdown);
                } else {
                    CoreNodeFormatter.renderTextBlockParagraphLines((Node)node, context, markdown);
                }
            } else {
                CoreNodeFormatter.renderLooseParagraph(node, context, markdown);
            }
        }
    }

    public static BasedSequence getSoftLineBreakSpan(Node node) {
        if (node == null) {
            return BasedSequence.NULL;
        }
        Node lastNode = node;
        for (Node nextNode = node.getNext(); nextNode != null && !(nextNode instanceof SoftLineBreak); nextNode = nextNode.getNext()) {
            lastNode = nextNode;
        }
        return Node.spanningChars((BasedSequence[])new BasedSequence[]{node.getChars(), lastNode.getChars()});
    }

    private void render(SoftLineBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getChars());
    }

    private void render(HardLineBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            markdown.append((CharSequence)node.getChars());
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    private void render(final HtmlEntity node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            markdown.append((CharSequence)node.getChars());
        } else {
            context.customPlaceholderFormat(htmlEntityPlaceholderGenerator, new TranslatingSpanRender(){

                @Override
                public void render(NodeFormatterContext context, MarkdownWriter markdown) {
                    markdown.appendNonTranslating((CharSequence)node.getChars());
                }
            });
        }
    }

    private void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getChars());
    }

    private void render(TextBase node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren((Node)node);
    }

    private void render(Code node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getOpeningMarker());
        markdown.appendNonTranslating((CharSequence)node.getText());
        markdown.append((CharSequence)node.getOpeningMarker());
    }

    private void render(HtmlBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (node.hasChildren()) {
            context.renderChildren((Node)node);
        } else {
            markdown.blankLine();
            switch (context.getRenderPurpose()) {
                case TRANSLATION_SPANS: 
                case TRANSLATED_SPANS: {
                    markdown.appendNonTranslating(this.myHtmlBlockPrefix, (CharSequence)node.getChars().trimEOL(), ">", (CharSequence)node.getChars().trimmedEOL());
                    break;
                }
                case TRANSLATED: {
                    markdown.openPreFormatted(true);
                    markdown.appendNonTranslating((CharSequence)node.getChars());
                    markdown.closePreFormatted();
                    break;
                }
                default: {
                    markdown.append((CharSequence)node.getChars());
                }
            }
            markdown.blankLine();
        }
    }

    private void render(HtmlCommentBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence text = node.getChars().subSequence(4, node.getChars().length() - 4);
        markdown.appendTranslating("<!--", (CharSequence)text, "-->", (CharSequence)node.getChars().trimmedEOL());
    }

    private void render(HtmlInnerBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: {
                markdown.appendNonTranslating(this.myHtmlBlockPrefix, (CharSequence)node.getChars().trimEOL(), ">", (CharSequence)node.getChars().trimmedEOL());
                break;
            }
            case TRANSLATED: {
                markdown.openPreFormatted(true);
                markdown.appendNonTranslating((CharSequence)node.getChars());
                markdown.closePreFormatted();
                break;
            }
            default: {
                markdown.append((CharSequence)node.getChars());
            }
        }
    }

    private void render(HtmlInnerBlockComment node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence text = node.getChars().subSequence(4, node.getChars().length() - 3);
        markdown.appendTranslating("<!--", (CharSequence)text, "-->");
    }

    private void render(HtmlInline node, NodeFormatterContext context, MarkdownWriter markdown) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: {
                String prefix = node.getChars().startsWith((CharSequence)"</") ? "</" : "<";
                markdown.appendNonTranslating(prefix, (CharSequence)node.getChars(), ">");
                break;
            }
            case TRANSLATED: {
                markdown.appendNonTranslating((CharSequence)node.getChars());
                break;
            }
            default: {
                markdown.append((CharSequence)node.getChars());
            }
        }
    }

    private void render(HtmlInlineComment node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence text = node.getChars().subSequence(4, node.getChars().length() - 3);
        markdown.appendTranslating("<!--", (CharSequence)text, "-->");
    }

    private void render(Reference node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private void render(AutoLink node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderAutoLink((DelimitedLinkNode)node, context, markdown, "hh://", ".h");
    }

    private void render(MailLink node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderAutoLink((DelimitedLinkNode)node, context, markdown, null, "@1.h");
    }

    private void renderAutoLink(DelimitedLinkNode node, NodeFormatterContext context, MarkdownWriter markdown, String prefix, String suffix) {
        if (context.isTransformingText()) {
            switch (context.getRenderPurpose()) {
                case TRANSLATION_SPANS: {
                    if (node.getOpeningMarker().isNull()) {
                        this.myTranslationStore.set(UNWRAPPED_AUTO_LINKS, (Object)true);
                        markdown.append("<");
                        markdown.appendNonTranslating(prefix, (CharSequence)node.getText(), suffix, null, new Consumer<String>(){

                            public void accept(String s) {
                                ((HashSet)CoreNodeFormatter.this.myTranslationStore.get(UNWRAPPED_AUTO_LINKS_MAP)).add(s);
                            }
                        });
                        markdown.append(">");
                        break;
                    }
                    markdown.append("<");
                    markdown.appendNonTranslating(prefix, (CharSequence)node.getText(), suffix);
                    markdown.append(">");
                    break;
                }
                case TRANSLATED_SPANS: {
                    markdown.append("<");
                    markdown.appendNonTranslating(prefix, (CharSequence)node.getText(), suffix);
                    markdown.append(">");
                    break;
                }
                case TRANSLATED: {
                    if (((Boolean)this.myTranslationStore.get(UNWRAPPED_AUTO_LINKS)).booleanValue() && ((HashSet)this.myTranslationStore.get(UNWRAPPED_AUTO_LINKS_MAP)).contains(node.getText().toString())) {
                        markdown.appendNonTranslating(prefix, (CharSequence)node.getText(), suffix);
                        break;
                    }
                    markdown.append("<");
                    markdown.appendNonTranslating(prefix, (CharSequence)node.getText(), suffix);
                    markdown.append(">");
                    break;
                }
                default: {
                    markdown.append((CharSequence)node.getChars());
                    break;
                }
            }
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    private void render(Image node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.lineIf(this.formatterOptions.keepImageLinksAtStart);
        if (context.isTransformingText()) {
            markdown.append((CharSequence)node.getTextOpeningMarker());
            markdown.appendTranslating((CharSequence)node.getText());
            markdown.append((CharSequence)node.getTextClosingMarker());
            markdown.append((CharSequence)node.getLinkOpeningMarker());
            markdown.append((CharSequence)node.getUrlOpeningMarker());
            markdown.appendNonTranslating((CharSequence)node.getPageRef());
            markdown.append((CharSequence)node.getUrlClosingMarker());
            if (node.getTitleOpeningMarker().isNotNull()) {
                markdown.append(' ');
                markdown.append((CharSequence)node.getTitleOpeningMarker());
                if (node.getTitle().isNotNull()) {
                    markdown.appendTranslating((CharSequence)node.getTitle());
                }
                markdown.append((CharSequence)node.getTitleClosingMarker());
            }
            markdown.append((CharSequence)node.getLinkClosingMarker());
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    private void render(Link node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.lineIf(this.formatterOptions.keepExplicitLinksAtStart);
        if (context.isTransformingText()) {
            markdown.append((CharSequence)node.getTextOpeningMarker());
            if (node.getText().isNotNull()) {
                if (node.getFirstChildAny(new Class[]{HtmlInline.class}) != null) {
                    context.renderChildren((Node)node);
                } else {
                    markdown.appendTranslating((CharSequence)node.getText());
                }
            }
            markdown.append((CharSequence)node.getTextClosingMarker());
            markdown.append((CharSequence)node.getLinkOpeningMarker());
            markdown.append((CharSequence)node.getUrlOpeningMarker());
            markdown.appendNonTranslating((CharSequence)node.getPageRef());
            markdown.append((CharSequence)node.getAnchorMarker());
            if (node.getAnchorRef().isNotNull()) {
                CharSequence anchorRef = context.transformAnchorRef((CharSequence)node.getPageRef(), (CharSequence)node.getAnchorRef());
                markdown.append(anchorRef);
            }
            markdown.append((CharSequence)node.getUrlClosingMarker());
            if (node.getTitleOpeningMarker().isNotNull()) {
                markdown.append(' ');
                markdown.append((CharSequence)node.getTitleOpeningMarker());
                if (node.getTitle().isNotNull()) {
                    markdown.appendTranslating((CharSequence)node.getTitle());
                }
                markdown.append((CharSequence)node.getTitleClosingMarker());
            }
            markdown.append((CharSequence)node.getLinkClosingMarker());
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    private void render(ImageRef node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            if (node.isReferenceTextCombined()) {
                markdown.append((CharSequence)node.getReferenceOpeningMarker());
                markdown.appendTranslating((CharSequence)node.getReference());
                markdown.append((CharSequence)node.getReferenceClosingMarker());
                markdown.append((CharSequence)node.getTextOpeningMarker());
                if (node.getText().isNotNull()) {
                    markdown.appendTranslating((CharSequence)node.getText());
                }
                markdown.append((CharSequence)node.getTextClosingMarker());
            } else {
                markdown.append((CharSequence)node.getTextOpeningMarker());
                markdown.appendTranslating((CharSequence)node.getText());
                markdown.append((CharSequence)node.getTextClosingMarker());
                markdown.append((CharSequence)node.getReferenceOpeningMarker());
                markdown.appendTranslating((CharSequence)node.getReference());
                markdown.append((CharSequence)node.getReferenceClosingMarker());
            }
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    private void render(LinkRef node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            if (node.isReferenceTextCombined()) {
                markdown.append((CharSequence)node.getReferenceOpeningMarker());
                markdown.appendTranslating((CharSequence)node.getReference());
                markdown.append((CharSequence)node.getReferenceClosingMarker());
                markdown.append((CharSequence)node.getTextOpeningMarker());
                if (node.getText().isNotNull()) {
                    if (node.getFirstChildAny(new Class[]{HtmlInline.class}) != null) {
                        context.renderChildren((Node)node);
                    } else {
                        markdown.appendTranslating((CharSequence)node.getText());
                    }
                }
                markdown.append((CharSequence)node.getTextClosingMarker());
            } else {
                markdown.append((CharSequence)node.getTextOpeningMarker());
                if (node.getText().isNotNull()) {
                    if (node.getFirstChildAny(new Class[]{HtmlInline.class}) != null) {
                        context.renderChildren((Node)node);
                    } else {
                        markdown.appendTranslating((CharSequence)node.getText());
                    }
                }
                markdown.append((CharSequence)node.getTextClosingMarker());
                markdown.append((CharSequence)node.getReferenceOpeningMarker());
                markdown.appendTranslating((CharSequence)node.getReference());
                markdown.append((CharSequence)node.getReferenceClosingMarker());
            }
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }
}

