/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.options;

import java.util.List;
import java.util.Stack;

public class DelimitedBuilder {
    private String delimiter;
    private StringBuilder out;
    private boolean hadSome = false;
    private boolean pending = false;
    private int lastLen = 0;
    private Stack<String> delimiterStack = null;

    public DelimitedBuilder() {
        this(",", 0);
    }

    public DelimitedBuilder(String delimiter) {
        this(delimiter, 0);
    }

    public DelimitedBuilder(String delimiter, int capacity) {
        this.delimiter = delimiter;
        this.out = capacity == 0 ? null : new StringBuilder(capacity);
    }

    public String toString() {
        if (this.delimiterStack != null && !this.delimiterStack.isEmpty()) {
            throw new IllegalStateException("Delimiter stack is not empty");
        }
        return this.out == null ? "" : this.out.toString();
    }

    public String getAndClear() {
        if (this.delimiterStack != null && !this.delimiterStack.isEmpty()) {
            throw new IllegalStateException("Delimiter stack is not empty");
        }
        String result = this.out == null ? "" : this.out.toString();
        this.clear();
        return result;
    }

    public DelimitedBuilder clear() {
        this.out = null;
        this.unmark();
        return this;
    }

    public String toStringOrNull() {
        if (this.delimiterStack != null && !this.delimiterStack.isEmpty()) {
            throw new IllegalStateException("Delimiter stack is not empty");
        }
        return this.out == null ? null : this.out.toString();
    }

    public DelimitedBuilder mark() {
        int length = this.out != null ? this.out.length() : 0;
        this.pending = this.lastLen != length;
        this.lastLen = length;
        return this;
    }

    public DelimitedBuilder unmark() {
        this.pending = false;
        this.lastLen = this.out != null ? this.out.length() : 0;
        return this;
    }

    public DelimitedBuilder push() {
        return this.push(this.delimiter);
    }

    public DelimitedBuilder push(String delimiter) {
        this.unmark();
        if (this.delimiterStack == null) {
            this.delimiterStack = new Stack();
        }
        this.delimiterStack.push(this.delimiter);
        this.delimiter = delimiter;
        return this;
    }

    public DelimitedBuilder pop() {
        if (this.delimiterStack == null || this.delimiterStack.isEmpty()) {
            throw new IllegalStateException("Nothing on the delimiter stack");
        }
        this.delimiter = this.delimiterStack.pop();
        return this;
    }

    private void doPending() {
        if (this.out == null) {
            this.out = new StringBuilder();
        }
        if (this.pending) {
            this.out.append(this.delimiter);
            this.pending = false;
        }
    }

    private DelimitedBuilder had() {
        return this;
    }

    public DelimitedBuilder append(char v) {
        this.doPending();
        this.out.append(v);
        return this.had();
    }

    public DelimitedBuilder append(int v) {
        this.doPending();
        this.out.append(v);
        return this.had();
    }

    public DelimitedBuilder append(boolean v) {
        this.doPending();
        this.out.append(v);
        return this.had();
    }

    public DelimitedBuilder append(long v) {
        this.doPending();
        this.out.append(v);
        return this.had();
    }

    public DelimitedBuilder append(float v) {
        this.doPending();
        this.out.append(v);
        return this.had();
    }

    public DelimitedBuilder append(double v) {
        this.doPending();
        this.out.append(v);
        return this.had();
    }

    public DelimitedBuilder append(String v) {
        if (!v.isEmpty()) {
            this.doPending();
            this.out.append(v);
        }
        return this.had();
    }

    public DelimitedBuilder append(String v, int start, int end) {
        if (start < end) {
            this.doPending();
            this.out.append(v, start, end);
        }
        return this.had();
    }

    public DelimitedBuilder append(CharSequence v) {
        if (v.length() > 0) {
            this.doPending();
            this.out.append(v);
        }
        return this.had();
    }

    public DelimitedBuilder append(CharSequence v, int start, int end) {
        if (start < end) {
            this.doPending();
            this.out.append(v, start, end);
        }
        return this.had();
    }

    public DelimitedBuilder append(char[] v) {
        if (v.length > 0) {
            this.doPending();
            this.out.append(v);
        }
        return this.had();
    }

    public DelimitedBuilder append(char[] v, int start, int end) {
        if (start < end) {
            this.doPending();
            this.out.append(v, start, end);
        }
        return this.had();
    }

    public <V> DelimitedBuilder appendAll(V[] v) {
        return this.appendAll(v, 0, v.length);
    }

    public <V> DelimitedBuilder appendAll(V[] v, int start, int end) {
        for (int i = start; i < end; ++i) {
            V item = v[i];
            this.append(item.toString());
            this.mark();
        }
        return this;
    }

    public <V> DelimitedBuilder appendAll(String delimiter, V[] v) {
        return this.appendAll(delimiter, v, 0, v.length);
    }

    public <V> DelimitedBuilder appendAll(String delimiter, V[] v, int start, int end) {
        int lastLength = this.out != null ? this.out.length() : 0;
        this.push(delimiter);
        this.appendAll(v, start, end);
        this.pop();
        if (lastLength != (this.out != null ? this.out.length() : 0)) {
            this.mark();
        } else {
            this.unmark();
        }
        return this;
    }

    public <V> DelimitedBuilder appendAll(List<? extends V> v) {
        return this.appendAll(v, 0, v.size());
    }

    public <V> DelimitedBuilder appendAll(List<? extends V> v, int start, int end) {
        for (int i = start; i < end; ++i) {
            V item = v.get(i);
            this.append(item.toString());
            this.mark();
        }
        return this;
    }

    public <V> DelimitedBuilder appendAll(String delimiter, List<? extends V> v) {
        return this.appendAll(delimiter, v, 0, v.size());
    }

    public <V> DelimitedBuilder appendAll(String delimiter, List<? extends V> v, int start, int end) {
        int lastLength = this.out != null ? this.out.length() : 0;
        this.push(delimiter);
        this.appendAll(v, start, end);
        this.pop();
        if (lastLength != (this.out != null ? this.out.length() : 0)) {
            this.mark();
        } else {
            this.unmark();
        }
        return this;
    }
}

