/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.asymmetric;

import com.xiaoleilu.hutool.crypto.CryptoException;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import com.xiaoleilu.hutool.crypto.asymmetric.AsymmetricCrypto;
import com.xiaoleilu.hutool.crypto.asymmetric.KeyType;
import com.xiaoleilu.hutool.lang.BCD;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSA
extends AsymmetricCrypto {
    private static final AsymmetricAlgorithm ALGORITHM_RSA = AsymmetricAlgorithm.RSA;

    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger privateExponent) {
        return SecureUtil.generatePrivateKey(ALGORITHM_RSA.getValue(), new RSAPrivateKeySpec(modulus, privateExponent));
    }

    public static PublicKey generatePublicKey(BigInteger modulus, BigInteger publicExponent) {
        return SecureUtil.generatePublicKey(ALGORITHM_RSA.getValue(), new RSAPublicKeySpec(modulus, publicExponent));
    }

    public RSA() {
        super(ALGORITHM_RSA);
    }

    public RSA(String privateKeyBase64, String publicKeyBase64) {
        super(ALGORITHM_RSA, privateKeyBase64, publicKeyBase64);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public RSA(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent) {
        this(RSA.generatePrivateKey(modulus, privateExponent), RSA.generatePublicKey(modulus, publicExponent));
    }

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public String encryptStr(String data, KeyType keyType) {
        return this.encryptStr(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public String encryptStr(String data, KeyType keyType, Charset charset) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = StrUtil.builder();
        this.lock.lock();
        try {
            String[] datas;
            this.clipher.init(1, key);
            for (String s : datas = StrUtil.split((CharSequence)data, keyLength - 11)) {
                sb.append(BCD.bcdToStr(this.clipher.doFinal(StrUtil.bytes((CharSequence)s, charset))));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public String decryptStr(String data, KeyType keyType, Charset charset) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = StrUtil.builder();
        this.lock.lock();
        try {
            byte[][] arrays;
            this.clipher.init(2, key);
            byte[] bcd = BCD.ascToBcd(StrUtil.bytes((CharSequence)data, charset));
            for (byte[] arr : arrays = ArrayUtil.split(bcd, keyLength)) {
                sb.append(StrUtil.str(this.clipher.doFinal(arr), charset));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }
}

