/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.impl.AnsiSqlDialect;
import com.xiaoleilu.hutool.db.dialect.impl.MysqlDialect;
import com.xiaoleilu.hutool.db.dialect.impl.OracleDialect;
import com.xiaoleilu.hutool.db.dialect.impl.PostgresqlDialect;
import com.xiaoleilu.hutool.db.dialect.impl.Sqlite3Dialect;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import javax.sql.DataSource;

public class DialectFactory {
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    public static final String DRIVER_SQLLITE3 = "org.sqlite.JDBC";
    public static final String DRIVER_HIVE = "org.apache.hadoop.hive.jdbc.HiveDriver";
    public static final String DRIVER_HIVE2 = "org.apache.hive.jdbc.HiveDriver";

    private DialectFactory() {
    }

    public static Dialect newDialect(String driverName) {
        if (StrUtil.isNotBlank(driverName)) {
            if (DRIVER_MYSQL.equalsIgnoreCase(driverName)) {
                return new MysqlDialect();
            }
            if (DRIVER_ORACLE.equalsIgnoreCase(driverName)) {
                return new OracleDialect();
            }
            if (DRIVER_SQLLITE3.equalsIgnoreCase(driverName)) {
                return new Sqlite3Dialect();
            }
            if (DRIVER_POSTGRESQL.equalsIgnoreCase(driverName)) {
                return new PostgresqlDialect();
            }
        }
        return new AnsiSqlDialect();
    }

    public static Dialect newDialect(DataSource ds) {
        return DialectFactory.newDialect(DbUtil.identifyDriver(ds));
    }

    public static Dialect newDialect(Connection conn) {
        return DialectFactory.newDialect(DbUtil.identifyDriver(conn));
    }
}

