/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.poi.excel;

import com.xiaoleilu.hutool.date.DateUtil;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.poi.excel.CellEditor;
import com.xiaoleilu.hutool.poi.excel.ExcelReader;
import com.xiaoleilu.hutool.poi.excel.editors.TrimEditor;
import com.xiaoleilu.hutool.poi.exceptions.POIException;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelUtil {
    public static ExcelReader getReader(String bookFilePath) {
        return ExcelUtil.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelUtil.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        return new ExcelReader(bookFilePath, sheetIndex);
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        return new ExcelReader(bookFile, sheetIndex);
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        return new ExcelReader(bookFile, sheetName);
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelUtil.getReader(bookStream, 0);
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        return new ExcelReader(bookStream, sheetIndex);
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        return new ExcelReader(bookStream, sheetName);
    }

    public static Workbook loadBook(String excelFilePath) {
        return ExcelUtil.loadBook(FileUtil.file(excelFilePath), null);
    }

    public static Workbook loadBook(File excelFile) {
        return ExcelUtil.loadBook(excelFile, null);
    }

    public static Workbook loadBook(File excelFile, String password) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook loadBook(InputStream in) {
        try {
            return WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static boolean isXls(InputStream in) {
        PushbackInputStream pin = IoUtil.toPushbackStream(in, 8);
        try {
            return POIFSFileSystem.hasPOIFSHeader((InputStream)pin);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isXlsx(InputStream in) {
        PushbackInputStream pin = IoUtil.toPushbackStream(in, 8);
        try {
            return DocumentFactoryHelper.hasOOXMLHeader((InputStream)pin);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        return ExcelUtil.getCellValue(cell, cell.getCellTypeEnum(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        if (null == cell) {
            return null;
        }
        return ExcelUtil.getCellValue(cell, cell.getCellTypeEnum(), cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return ExcelUtil.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Object value;
        if (null == cell) {
            return null;
        }
        if (null == cellType) {
            cellType = cell.getCellTypeEnum();
        }
        switch (cellType) {
            case NUMERIC: {
                value = ExcelUtil.getNumericValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = ExcelUtil.getCellValue(cell, cell.getCachedFormulaResultTypeEnum(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static Map<String, PictureData> getPicMap(Workbook workbook, int sheetIndex) {
        Assert.notNull(workbook, "Workbook must be not null !", new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        if (workbook instanceof HSSFWorkbook) {
            return ExcelUtil.getPicMapXls((HSSFWorkbook)workbook, sheetIndex);
        }
        if (workbook instanceof XSSFWorkbook) {
            return ExcelUtil.getPicMapXlsx((XSSFWorkbook)workbook, sheetIndex);
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Workbook type [{}] is not supported!", workbook.getClass()));
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (row < ca.getFirstRow() || row > ca.getLastRow() || column < ca.getFirstColumn() || column > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    private static Map<String, PictureData> getPicMapXls(HSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> picMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (CollectionUtil.isNotEmpty(pictures)) {
            HSSFSheet sheet = workbook.getSheetAt(sheetIndex);
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                int pictureIndex = ((HSSFPicture)shape).getPictureIndex() - 1;
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                picMap.put(StrUtil.format((CharSequence)"{}_{}", anchor.getRow1(), anchor.getCol1()), (PictureData)pictures.get(pictureIndex));
            }
        }
        return picMap;
    }

    private static Map<String, PictureData> getPicMapXlsx(XSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic = (XSSFPicture)shape;
                CTMarker ctMarker = pic.getPreferredSize().getFrom();
                sheetIndexPicMap.put(StrUtil.format((CharSequence)"{}_{}", ctMarker.getRow(), ctMarker.getCol()), (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    private static Object getNumericValue(Cell cell) {
        String format;
        double value = cell.getNumericCellValue();
        CellStyle style = cell.getCellStyle();
        if (null == style) {
            return value;
        }
        short formatIndex = style.getDataFormat();
        if (ExcelUtil.isDateType(formatIndex, format = style.getDataFormatString())) {
            return DateUtil.date(cell.getDateCellValue());
        }
        if (null != format && format.indexOf(46) < 0) {
            return (long)value;
        }
        return value;
    }

    private static boolean isDateType(int formatIndex, String format) {
        if (formatIndex == 14 || formatIndex == 31 || formatIndex == 57 || formatIndex == 58 || formatIndex == 20 || formatIndex == 32) {
            return true;
        }
        return org.apache.poi.ss.usermodel.DateUtil.isADateFormat((int)formatIndex, (String)format);
    }
}

