/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.Lang;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String X36 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String X62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final char[] AZ09CHAR_36 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] AZ09CHAR_62 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] AZCHAR_26 = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static Object[][] UTF8UNICODE = new Object[][]{{0, 127, "C0\u63a7\u5236\u7b26\u53ca\u57fa\u672c\u62c9\u4e01\u6587"}, {128, 255, "C1\u63a7\u5236\u7b26\u53ca\u62c9\u4e01\u6587\u8865\u5145-1"}, {256, 383, "\u62c9\u4e01\u6587\u6269\u5c55-A"}, {384, 591, "\u62c9\u4e01\u6587\u6269\u5c55-B"}, {592, 687, "\u56fd\u9645\u97f3\u6807\u6269\u5c55"}, {688, 767, "\u7a7a\u767d\u4fee\u9970\u5b57\u6bcd"}, {768, 879, "\u7ed3\u5408\u7528\u8bfb\u97f3\u7b26\u53f7"}, {880, 1023, "\u5e0c\u814a\u6587\u53ca\u79d1\u666e\u7279\u6587"}, {1024, 1279, "\u897f\u91cc\u5c14\u5b57\u6bcd"}, {1280, 1327, "\u897f\u91cc\u5c14\u5b57\u6bcd\u8865\u5145"}, {1328, 1423, "\u4e9a\u7f8e\u5c3c\u4e9a\u8bed"}, {1424, 1535, "\u5e0c\u4f2f\u6765\u6587"}, {1536, 1791, "\u963f\u62c9\u4f2f\u6587"}, {1792, 1871, "\u53d9\u5229\u4e9a\u6587"}, {1872, 1919, "\u963f\u62c9\u4f2f\u6587\u8865\u5145"}, {1920, 1983, "\u9a6c\u5c14\u4ee3\u592b\u8bed"}, {1984, 2047, "\u897f\u975e\u66f8\u9762\u8a9e\u8a00"}, {2048, 2143, "\u963f\u7ef4\u65af\u5854\u8bed\u53ca\u5df4\u5217\u7ef4\u8bed"}, {2144, 2175, "Mandaic"}, {2176, 2223, "\u6492\u9a6c\u5229\u4e9a\u8bed"}, {2304, 2431, "\u5929\u57ce\u6587\u4e66"}, {2432, 2559, "\u5b5f\u52a0\u62c9\u8bed"}, {2560, 2687, "\u9521\u514b\u6559\u6587"}, {2688, 2815, "\u53e4\u5409\u62c9\u7279\u6587"}, {2816, 2943, "\u5965\u91cc\u4e9a\u6587"}, {2944, 3071, "\u6cf0\u7c73\u5c14\u6587"}, {3072, 3199, "\u6cf0\u5362\u56fa\u6587"}, {3200, 3327, "\u5361\u7eb3\u8fbe\u6587"}, {3328, 3455, "\u5fb7\u62c9\u7ef4\u65cf\u8bed"}, {3456, 3583, "\u50e7\u4f3d\u7f57\u8bed"}, {3584, 3711, "\u6cf0\u6587"}, {3712, 3839, "\u8001\u631d\u6587"}, {3840, 4095, "\u85cf\u6587"}, {4096, 4255, "\u7f05\u7538\u8bed"}, {4256, 4351, "\u683c\u9c81\u5409\u4e9a\u8bed"}, {4352, 4607, "\u671d\u9c9c\u6587"}, {4608, 4991, "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u8bed"}, {4992, 5023, "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u8bed\u8865\u5145"}, {5024, 5119, "\u5207\u7f57\u57fa\u8bed"}, {5120, 5759, "\u7edf\u4e00\u52a0\u62ff\u5927\u571f\u8457\u8bed\u97f3\u8282"}, {5760, 5791, "\u6b27\u7518\u5b57\u6bcd"}, {5792, 5887, "\u5982\u5c3c\u6587"}, {5888, 5919, "\u5854\u52a0\u62c9\u8bed"}, {5920, 5951, "Hanun\u00f3o"}, {5952, 5983, "Buhid"}, {5984, 6015, "Tagbanwa"}, {6016, 6143, "\u9ad8\u68c9\u8bed"}, {6144, 6319, "\u8499\u53e4\u6587"}, {6320, 6399, "Cham"}, {6400, 6479, "Limbu"}, {6480, 6527, "\u5fb7\u5b8f\u6cf0\u8bed"}, {6528, 6623, "\u65b0\u50a3\u4ec2\u8bed"}, {6624, 6655, "\u9ad8\u68c9\u8bed\u8bb0\u53f7"}, {6656, 6687, "Buginese"}, {6688, 6751, "Batak"}, {6784, 6895, "Lanna"}, {6912, 7039, "\u5df4\u5398\u8bed"}, {7040, 7088, "\u5dfd\u4ed6\u8bed"}, {7104, 7167, "Pahawh Hmong"}, {7168, 7247, "\u96f7\u5e03\u67e5\u8bed"}, {7248, 7295, "Ol Chiki"}, {7296, 7391, "\u66fc\u5c3c\u666e\u5c14\u8bed"}, {7424, 7551, "\u8bed\u97f3\u5b66\u6269\u5c55"}, {7552, 7615, "\u8bed\u97f3\u5b66\u6269\u5c55\u8865\u5145"}, {7616, 7679, "\u7ed3\u5408\u7528\u8bfb\u97f3\u7b26\u53f7\u8865\u5145"}, {7680, 7935, "\u62c9\u4e01\u6587\u6269\u5145\u9644\u52a0"}, {7936, 8191, "\u5e0c\u814a\u8bed\u6269\u5145"}, {8192, 8303, "\u5e38\u7528\u6807\u70b9"}, {8304, 8351, "\u4e0a\u6807\u53ca\u4e0b\u6807"}, {8352, 8399, "\u8d27\u5e01\u7b26\u53f7"}, {8400, 8447, "\u7ec4\u5408\u7528\u8bb0\u53f7"}, {8448, 8527, "\u5b57\u6bcd\u5f0f\u7b26\u53f7"}, {8528, 8591, "\u6570\u5b57\u5f62\u5f0f"}, {8592, 8703, "\u7bad\u5934"}, {8704, 8959, "\u6570\u5b66\u8fd0\u7b97\u7b26"}, {8960, 9215, "\u6742\u9879\u5de5\u4e1a\u7b26\u53f7"}, {9216, 9279, "\u63a7\u5236\u56fe\u7247"}, {9280, 9311, "\u5149\u5b66\u8bc6\u522b\u7b26"}, {9312, 9471, "\u5c01\u95ed\u5f0f\u5b57\u6bcd\u6570\u5b57"}, {9472, 9599, "\u5236\u8868\u7b26"}, {9600, 9631, "\u65b9\u5757\u5143\u7d20"}, {9632, 9727, "\u51e0\u4f55\u56fe\u5f62"}, {9728, 9983, "\u6742\u9879\u7b26\u53f7"}, {9984, 10175, "\u5370\u5237\u7b26\u53f7"}, {10176, 10223, "\u6742\u9879\u6570\u5b66\u7b26\u53f7-A"}, {10224, 10239, "\u8ffd\u52a0\u7bad\u5934-A"}, {10240, 10495, "\u76f2\u6587\u70b9\u5b57\u6a21\u578b"}, {10496, 10623, "\u8ffd\u52a0\u7bad\u5934-B"}, {10624, 10751, "\u6742\u9879\u6570\u5b66\u7b26\u53f7-B"}, {10752, 11007, "\u8ffd\u52a0\u6570\u5b66\u8fd0\u7b97\u7b26"}, {11008, 11263, "\u6742\u9879\u7b26\u53f7\u548c\u7bad\u5934"}, {11264, 11359, "\u683c\u62c9\u54e5\u91cc\u5b57\u6bcd"}, {11360, 11391, "\u62c9\u4e01\u6587\u6269\u5c55-C"}, {11392, 11519, "\u53e4\u57c3\u53ca\u8bed"}, {11520, 11567, "\u683c\u9c81\u5409\u4e9a\u8bed\u8865\u5145"}, {11568, 11647, "\u63d0\u975e\u7eb3\u6587"}, {11648, 11743, "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u8bed\u6269\u5c55"}, {11776, 11903, "\u8ffd\u52a0\u6807\u70b9"}, {11904, 12031, "CJK \u90e8\u9996\u8865\u5145"}, {12032, 12255, "\u5eb7\u7199\u5b57\u5178\u90e8\u9996"}, {12272, 12287, "\u8868\u610f\u6587\u5b57\u63cf\u8ff0\u7b26"}, {12288, 12351, "CJK \u7b26\u53f7\u548c\u6807\u70b9"}, {12352, 12447, "\u65e5\u6587\u5e73\u5047\u540d"}, {12448, 12543, "\u65e5\u6587\u7247\u5047\u540d"}, {12544, 12591, "\u6ce8\u97f3\u5b57\u6bcd"}, {12592, 12687, "\u671d\u9c9c\u6587\u517c\u5bb9\u5b57\u6bcd"}, {12688, 12703, "\u8c61\u5f62\u5b57\u6ce8\u91ca\u6807\u5fd7"}, {12704, 12735, "\u6ce8\u97f3\u5b57\u6bcd\u6269\u5c55"}, {12736, 12783, "CJK \u7b14\u753b"}, {12784, 12799, "\u65e5\u6587\u7247\u5047\u540d\u8bed\u97f3\u6269\u5c55"}, {12800, 13055, "\u5c01\u95ed\u5f0f CJK \u6587\u5b57\u548c\u6708\u4efd"}, {13056, 13311, "CJK \u517c\u5bb9"}, {13312, 19903, "CJK \u7edf\u4e00\u8868\u610f\u7b26\u53f7\u6269\u5c55 A"}, {19904, 19967, "\u6613\u7ecf\u516d\u5341\u56db\u5366\u7b26\u53f7\t"}, {19968, 40895, "CJK \u7edf\u4e00\u8868\u610f\u7b26\u53f7"}, {40960, 42127, "\u5f5d\u6587\u97f3\u8282"}, {42128, 42191, "\u5f5d\u6587\u5b57\u6839"}, {42240, 42527, "Vai"}, {42592, 42751, "\u7edf\u4e00\u52a0\u62ff\u5927\u571f\u8457\u8bed\u97f3\u8282\u8865\u5145"}, {42752, 42783, "\u58f0\u8c03\u4fee\u9970\u5b57\u6bcd"}, {42784, 43007, "\u62c9\u4e01\u6587\u6269\u5c55-D"}, {43008, 43055, "Syloti Nagri"}, {43072, 43135, "\u516b\u601d\u5df4\u5b57"}, {43136, 43231, "Saurashtra"}, {43264, 43391, "\u722a\u54c7\u8bed"}, {43392, 43487, "Chakma"}, {43520, 43583, "Varang Kshiti"}, {43584, 43631, "Sorang Sompeng"}, {43648, 43743, "Newari"}, {43776, 43871, "\u8d8a\u5357\u50a3\u8bed"}, {43904, 43936, "Kayah Li"}, {44032, 55215, "\u671d\u9c9c\u6587\u97f3\u8282"}, {55296, 56319, "High-half zone of UTF-16"}, {56320, 57343, "Low-half zone of UTF-16"}, {57344, 63743, "\u81ea\u884c\u4f7f\u7528\u5340\u57df"}, {63744, 64255, "CJK \u517c\u5bb9\u8c61\u5f62\u6587\u5b57"}, {64256, 64335, "\u5b57\u6bcd\u8868\u9054\u5f62\u5f0f"}, {64336, 65023, "\u963f\u62c9\u4f2f\u8868\u9054\u5f62\u5f0fA"}, {65024, 65039, "\u53d8\u91cf\u9009\u62e9\u7b26"}, {65040, 65055, "\u7ad6\u6392\u5f62\u5f0f"}, {65056, 65071, "\u7ec4\u5408\u7528\u534a\u7b26\u53f7"}, {65072, 65103, "CJK \u517c\u5bb9\u5f62\u5f0f"}, {65104, 65135, "\u5c0f\u578b\u53d8\u4f53\u5f62\u5f0f"}, {65136, 65279, "\u963f\u62c9\u4f2f\u8868\u9054\u5f62\u5f0fB"}, {65280, 65519, "\u534a\u578b\u53ca\u5168\u578b\u5f62\u5f0f"}, {65520, 65535, "\u7279\u6b8a"}};

    public static String intTo36(int num) {
        StringBuffer sBuffer = new StringBuffer();
        if (num == 0) {
            sBuffer.append("0");
        }
        while (num > 0) {
            sBuffer.append(AZ09CHAR_36[num % 36]);
            num /= 36;
        }
        return sBuffer.reverse().toString();
    }

    public static String intTo62(int num) {
        StringBuffer sBuffer = new StringBuffer();
        if (num == 0) {
            sBuffer.append("0");
        }
        while (num > 0) {
            sBuffer.append(AZ09CHAR_62[num % 62]);
            num /= 62;
        }
        return sBuffer.reverse().toString();
    }

    public static int _36ToInt(String string) {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        for (int i = 0; i < X36.length(); ++i) {
            map.put(Character.valueOf(X36.charAt(i)), i);
        }
        int size = string.length();
        int num = 0;
        for (int i = 0; i < size; ++i) {
            String char2str = String.valueOf(string.charAt(i)).toUpperCase();
            num = (int)((double)((Integer)map.get(Character.valueOf(char2str.charAt(0)))).intValue() * Math.pow(36.0, size - i - 1) + (double)num);
        }
        return num;
    }

    public static String Utf8ToString(String text) {
        return StringUtil.StringToUtf8(text);
    }

    public static String StringToUtf8(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        for (int j = 0; j < text.length(); ++j) {
            String s = Integer.toString(text.charAt(j), 16);
            while (s.length() < 4) {
                s = "0" + s;
            }
            output.append("\\u" + s);
        }
        return output.toString();
    }

    public static String utf8ToString(String text) {
        if (text == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String group = matcher.group(2);
            char ch = (char)Integer.parseInt(group, 16);
            String group1 = matcher.group(1);
            text = text.replace(group1, ch + "");
        }
        return text;
    }

    public static String getStringLanguage(String text) {
        String result = null;
        int param = 0;
        param = text.length() == 1 ? StringUtil.Utf8ToInt(text) : Lang.stringToInt(text, 0, 16);
        if (param == 0) {
            return null;
        }
        for (int i = 0; i < UTF8UNICODE.length && result == null; ++i) {
            int one = (Integer)UTF8UNICODE[i][0];
            int two = (Integer)UTF8UNICODE[i][1];
            if (param < one || param > two) continue;
            result = UTF8UNICODE[i][2] + "";
        }
        if (result == null) {
            result = "\u6ca1\u6709\u53d1\u73b0\u6b64\u6587\u5b57\u5bf9\u5e94\u7684\u8bed\u8a00";
        }
        return result;
    }

    public static int Utf8ToInt(String text) {
        String result = Integer.toString(text.charAt(0), 16);
        if (result.length() == 0) {
            return 0;
        }
        return Lang.stringToInt(result, 0, 16);
    }

    public static String filterHtmlTag(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("<[.[^<]]*>", "");
    }

    public static List<String> split(String content, String regex) {
        String[] sa = content.split(regex);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < sa.length; ++i) {
            if (sa[i] == null || sa[i].length() <= 0) continue;
            list.add(sa[i]);
        }
        return list;
    }

    public static String insert(String sourceString, String insertString, int place) {
        if (insertString == null || insertString.length() == 0 || place == -1) {
            return sourceString;
        }
        String start = sourceString.substring(0, place);
        String end = sourceString.substring(place, sourceString.length());
        String newString = start + insertString + end;
        return newString;
    }

    public static String subStringReplace(String text, String startString, String endString, String replaceNewString) {
        int start = text.indexOf(startString);
        if (start == -1) {
            return text;
        }
        int end = text.substring(start, text.length()).indexOf(endString);
        if (end == -1) {
            return text;
        }
        String stringStart = text.substring(0, start);
        String stringEnd = text.substring((end += start) + endString.length(), text.length());
        return stringStart + replaceNewString + stringEnd;
    }

    public static String getRandomAZ(int length) {
        int maxNum = 26;
        int count = 0;
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < length) {
            int i = Math.abs(r.nextInt(26));
            if (i < 0 || i >= AZCHAR_26.length) continue;
            pwd.append(AZCHAR_26[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static String getRandom09AZ(int length) {
        int maxNum = 36;
        int count = 0;
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < length) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= AZ09CHAR_36.length) continue;
            pwd.append(AZ09CHAR_36[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static String filterXss(String text) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll(";", "\uff1b");
        String[] filterTagArray = new String[]{"script", "frame "};
        for (int i = 0; i < filterTagArray.length; ++i) {
            Pattern p = Pattern.compile(filterTagArray[i], 2);
            Matcher m = p.matcher(text);
            text = m.replaceAll("xss_" + filterTagArray[i]);
        }
        Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("</script>", 2);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("<script(.*?)>", 42);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("e\u00adxpression\\((.*?)\\)", 42);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("javascript:", 2);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("vbscript:", 2);
        text = scriptPattern.matcher(text).replaceAll("");
        scriptPattern = Pattern.compile("onload(.*?)=", 42);
        text = scriptPattern.matcher(text).replaceAll("");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("\\(", "&#40;");
        text = text.replaceAll("\\)", "&#41;");
        text = text.replaceAll("'", "&#39;");
        text = text.replaceAll("eval\\((.*)\\)", "");
        text = text.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        text = text.replaceAll("script", "");
        return text;
    }

    public static String inputStreamToString(InputStream in, String encode) throws IOException {
        int length;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        String str = result.toString(encode);
        return str;
    }

    public static InputStream stringToInputStream(String text, String encode) throws UnsupportedEncodingException {
        if (text == null) {
            return null;
        }
        return new ByteArrayInputStream(text.getBytes(encode));
    }

    public static String removeBlank(String str) {
        String newStr = null;
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            newStr = m.replaceAll("");
        }
        return newStr;
    }

    public static boolean StringEqual(String S1, String S2) {
        return StringUtil.StringEqual(S1, S2, false);
    }

    public static boolean StringEqual(String S1, String S2, boolean removeBlank) {
        return StringUtil.StringEqual(S1, S2, removeBlank, false);
    }

    public static boolean StringEqual(String S1, String S2, boolean removeBlank, boolean ignoreNull) {
        if (ignoreNull) {
            if (S1 == null || S1.equals("null")) {
                S1 = "";
            }
            if (S2 == null || S2.equals("null")) {
                S2 = "";
            }
        } else {
            if (S1 == null && S2 != null) {
                return false;
            }
            if (S1 != null && S2 == null) {
                return false;
            }
            if (S1 == null && S2 == null) {
                return true;
            }
        }
        if (removeBlank) {
            if (S1.length() > 0) {
                S1 = StringUtil.removeBlank(S1);
            }
            if (S2.length() > 0) {
                S2 = StringUtil.removeBlank(S2);
            }
        }
        return S1.equals(S2);
    }

    public static String firstCharToLowerCase(String s) {
        if (s == null || s.equals("")) {
            return "";
        }
        if (!Character.isLowerCase(s.charAt(0))) {
            s = Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
        Pattern p = Pattern.compile("[A-Z]");
        StringBuilder builder = new StringBuilder(s);
        Matcher mc = p.matcher(s);
        int i = 0;
        while (mc.find()) {
            builder.replace(mc.start() + i, mc.end() + i, "_" + mc.group().toLowerCase());
            ++i;
        }
        if ('_' == builder.charAt(0)) {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    public static String encrypt(String text, int shiftNum) {
        char[] array = text.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (char)(array[i] ^ '\u0001');
        }
        return new String(array);
    }

    public static String stringToUrl(String content) {
        try {
            String str = URLEncoder.encode(content, "UTF-8");
            str = str.replaceAll("\\+", "%20");
            return str;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static String urlToString(String content) {
        if (content == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        int l = content.length();
        int ch = -1;
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            int b;
            char c = content.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = content.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = content.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case '+': {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more != 0) continue;
                sbuf.append((char)sumb);
                continue;
            }
            if ((b & 0x80) == 0) {
                sbuf.append((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
                continue;
            }
            if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
                continue;
            }
            if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
                continue;
            }
            sumb = b & 1;
            more = 5;
        }
        return sbuf.toString();
    }

    public static String replaceAll(String text, String regex, String replacement) {
        if (text == null || regex == null) {
            return text;
        }
        if (replacement == null) {
            replacement = "";
        }
        String[] s = new String[]{"?", "(", ")", "{", "}"};
        for (int i = 0; i < s.length; ++i) {
            regex = regex.replaceAll("\\" + s[i], "\\\\" + s[i]);
        }
        text = text.replaceAll(regex, replacement);
        return text;
    }

    public static String filterEnglishSpecialSymbol(String text) {
        if (text == null) {
            return null;
        }
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(text);
        return m.replaceAll("").trim();
    }

    public static String filterChineseSpecialSymbol(String text) {
        String regEx = "[\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(text);
        return m.replaceAll("").trim();
    }

    public static String halfToFullChar(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] cha = str.toCharArray();
        for (int i = 0; i < cha.length; ++i) {
            if (cha[i] == ' ') {
                cha[i] = 12288;
                continue;
            }
            if (cha[i] >= '\u007f') continue;
            cha[i] = (char)(cha[i] + 65248);
        }
        return new String(cha);
    }

    public static String subString(String sourceString, String startString, String endString, int matchType) {
        int start = 0;
        if (startString != null && startString.length() != 0) {
            start = matchType == 1 || matchType == 2 ? sourceString.indexOf(startString) : sourceString.lastIndexOf(startString);
            start = start < 0 ? 0 : (start += startString.length());
        }
        int end = 0;
        if (endString != null && endString.length() != 0) {
            if (matchType == 1 || matchType == 3) {
                end = sourceString.lastIndexOf(endString);
                if (end < 0) {
                    end = -1;
                }
            } else {
                String xnx3_string = start > -1 ? sourceString.substring(start) : sourceString;
                end = xnx3_string.indexOf(endString);
                if (end < 0) {
                    end = 0;
                }
                end += start;
            }
        } else {
            end = sourceString.length();
        }
        if (start == -1 || end == -1) {
            return null;
        }
        return sourceString.substring(start, end);
    }

    public static String subString(String sourceString, String startString, String endString) {
        return StringUtil.subString(sourceString, startString, endString, 1);
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.stringToUrl("\u5b89\u8fbe\u5e02\u5c06\u5ba2\u62374dsbh&34%23"));
        System.out.println(StringUtil.urlToString("%E5%AE%89%E8%BE%BE%E5%B8%82%E5%B0%86%E5%AE%A2%E6%88%B74dsbh%2634%2523"));
        System.out.println(StringUtil.intTo36(100000));
        System.out.println(StringUtil._36ToInt("255s"));
    }
}

