/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.provider.impl;

import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.remoting.provider.annotation.XxlRpcService;
import com.xxl.rpc.util.XxlRpcException;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XxlRpcSpringProviderFactory
extends XxlRpcProviderFactory
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map serviceBeanMap = applicationContext.getBeansWithAnnotation(XxlRpcService.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (serviceBean.getClass().getInterfaces().length == 0) {
                    throw new XxlRpcException("xxl-rpc, service(XxlRpcService) must inherit interface.");
                }
                XxlRpcService xxlRpcService = serviceBean.getClass().getAnnotation(XxlRpcService.class);
                String iface = serviceBean.getClass().getInterfaces()[0].getName();
                String version = xxlRpcService.version();
                super.addService(iface, version, serviceBean);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.start();
    }

    public void destroy() throws Exception {
        super.stop();
    }
}

