/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.ladda;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.ladda.LaddaCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.ladda.LaddaJsReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.SpinJsReference;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class LaddaBehavior
extends Behavior {
    private Effect effect = Effect.ZOOM_OUT;
    private String spinnerColor;
    private int spinnerSize;

    public LaddaBehavior withEffect(Effect effect) {
        this.effect = (Effect)((Object)Args.notNull((Object)((Object)effect), (String)"effect"));
        return this;
    }

    public LaddaBehavior withSpinnerColor(String color) {
        this.spinnerColor = color;
        return this;
    }

    public LaddaBehavior withSpinnerSize(int size) {
        this.spinnerSize = size;
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"ladda-button"});
        Attributes.set((ComponentTag)tag, (String)"data-style", (String)this.effect.cssClassName());
        if (!Strings.isEmpty((CharSequence)this.spinnerColor)) {
            Attributes.set((ComponentTag)tag, (String)"data-spinner-color", (String)this.spinnerColor);
        }
        if (this.spinnerSize > 0) {
            Attributes.set((ComponentTag)tag, (String)"data-spinner-size", (String)String.valueOf(this.spinnerSize));
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)LaddaCssReference.INSTANCE));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SpinJsReference.INSTANCE));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)LaddaJsReference.INSTANCE));
    }

    public static enum Effect implements ICssClassNameProvider
    {
        EXPAND_LEFT,
        EXPAND_RIGHT,
        EXPAND_UP,
        EXPAND_DOWN,
        ZOOM_IN,
        ZOOM_OUT,
        SLIDE_LEFT,
        SLIDE_RIGHT,
        SLIDE_UP,
        SLIDE_DOWN,
        CONTACT;


        public String cssClassName() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }
}

