/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.boot.admin.client")
public class AdminClientProperties {
    private String managementUrl;
    private String serviceUrl;
    private String healthUrl;
    @Value(value="${spring.application.name:spring-boot-application}")
    private String name;
    @Value(value="${endpoints.health.id:health}")
    private String healthEndpointId;
    private boolean preferIp = false;
    @Autowired
    private ManagementServerProperties management;
    @Autowired
    private ServerProperties server;
    private Integer serverPort;
    private Integer managementPort;
    private boolean ready = false;

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        this.serverPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.server.port", Integer.class);
        this.managementPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.management.port", Integer.class, (Object)this.serverPort);
        this.ready = true;
    }

    public String getManagementUrl() {
        if (this.managementUrl != null) {
            return this.managementUrl;
        }
        if ((this.managementPort == null || this.managementPort.equals(this.serverPort)) && this.getServiceUrl() != null) {
            return this.append(this.append(this.getServiceUrl(), this.server.getServletPrefix()), this.management.getContextPath());
        }
        if (this.ready && this.managementPort == null) {
            throw new IllegalStateException("serviceUrl must be set when deployed to servlet-container");
        }
        if (this.preferIp) {
            Assert.notNull((Object)this.management.getAddress(), (String)"management.address must be set when using preferIp");
            return this.append(this.append(this.createLocalUri(this.management.getAddress().getHostAddress(), this.managementPort), this.server.getContextPath()), this.management.getContextPath());
        }
        return this.append(this.append(this.createLocalUri(this.getHostname(), this.managementPort), this.server.getContextPath()), this.management.getContextPath());
    }

    public void setManagementUrl(String managementUrl) {
        this.managementUrl = managementUrl;
    }

    public String getHealthUrl() {
        if (this.healthUrl != null) {
            return this.healthUrl;
        }
        return this.append(this.getManagementUrl(), this.healthEndpointId);
    }

    public void setHealthUrl(String healthUrl) {
        this.healthUrl = healthUrl;
    }

    public String getServiceUrl() {
        if (this.serviceUrl != null) {
            return this.serviceUrl;
        }
        if (this.ready && this.serverPort == null) {
            throw new IllegalStateException("serviceUrl must be set when deployed to servlet-container");
        }
        if (this.preferIp) {
            Assert.notNull((Object)this.server.getAddress(), (String)"server.address must be set when using preferIp");
            return this.append(this.createLocalUri(this.server.getAddress().getHostAddress(), this.serverPort), this.server.getContextPath());
        }
        return this.append(this.createLocalUri(this.getHostname(), this.serverPort), this.server.getContextPath());
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public boolean isReady() {
        return this.ready;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreferIp(boolean preferIp) {
        this.preferIp = preferIp;
    }

    public boolean isPreferIp() {
        return this.preferIp;
    }

    private String createLocalUri(String host, int port) {
        String scheme = this.server.getSsl() != null && this.server.getSsl().isEnabled() ? "https" : "http";
        return scheme + "://" + host + ":" + port;
    }

    private String append(String uri, String path) {
        String baseUri = uri.replaceFirst("/+$", "");
        if (StringUtils.isEmpty((Object)path)) {
            return baseUri;
        }
        String normPath = path.replaceFirst("^/+", "").replaceFirst("/+$", "");
        return baseUri + "/" + normPath;
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }
}

