/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.util;

import de.ruedigermoeller.serialization.util.FSTObject2IntMap;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.util.HashMap;

public class FSTInt2ObjectMap<V> {
    public int[] mKeys;
    public Object[] mValues;
    public int mNumberOfElements;
    FSTInt2ObjectMap<V> next;
    private static final int GROWFAC = 2;
    static int miss = 0;
    static int hit = 0;

    public FSTInt2ObjectMap(int initialSize) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTObject2IntMap.adjustSize(initialSize * 2);
        this.mKeys = new int[initialSize];
        this.mValues = new Object[initialSize];
        this.mNumberOfElements = 0;
    }

    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final void put(int key, V value) {
        int hash = key & Integer.MAX_VALUE;
        if (key == 0 && value == null) {
            throw new RuntimeException("key value pair not supported " + key + " " + value);
        }
        this.putHash(key, value, hash, this);
    }

    final void putHash(int key, V value, int hash, FSTInt2ObjectMap<V> parent) {
        int idx;
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (parent != null) {
                if ((parent.mNumberOfElements + this.mNumberOfElements) * 2 > parent.mKeys.length) {
                    parent.resize(parent.mKeys.length * 2);
                    parent.put(key, value);
                    return;
                }
                this.resize(this.mKeys.length * 2);
            } else {
                this.resize(this.mKeys.length * 2);
            }
        }
        if (this.mKeys[idx = hash % this.mKeys.length] == 0 && this.mValues[idx] == null) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            this.mKeys[idx] = key;
        } else if (this.mKeys[idx] == key) {
            this.mValues[idx] = value;
        } else {
            this.putNext(hash, key, value);
        }
    }

    final void putNext(int hash, int key, V value) {
        if (this.next == null) {
            int newSiz = this.mNumberOfElements / 3;
            this.next = new FSTInt2ObjectMap<V>(newSiz);
        }
        this.next.putHash(key, value, hash, this);
    }

    public final V get(int key) {
        int hash = key & Integer.MAX_VALUE;
        return this.getHash(key, hash);
    }

    final V getHash(int key, int hash) {
        int idx = hash % this.mKeys.length;
        int mKey = this.mKeys[idx];
        Object mValue = this.mValues[idx];
        if (mKey == 0 && mValue == null) {
            return null;
        }
        if (mKey == key) {
            return (V)mValue;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.getHash(key, hash);
    }

    final void resize(int newSize) {
        newSize = FSTObject2IntMap.adjustSize(newSize);
        int[] oldTabKey = this.mKeys;
        Object[] oldTabVal = this.mValues;
        this.mKeys = new int[newSize];
        this.mValues = new Object[newSize];
        this.mNumberOfElements = 0;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == 0 && oldTabVal[n] == null) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            FSTInt2ObjectMap<V> oldNext = this.next;
            this.next = null;
            super.rePut(this);
        }
    }

    private void rePut(FSTInt2ObjectMap<V> kfstObject2IntMap) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            int mKey = this.mKeys[i];
            if (mKey == 0 && this.mValues[i] == null) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            super.rePut(kfstObject2IntMap);
        }
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }

    public static void main(String[] arg) {
        for (int jj = 0; jj < 100; ++jj) {
            int i;
            int j;
            int i2;
            int count = 10;
            miss = 0;
            hit = 0;
            FSTInt2ObjectMap<Object> map = new FSTInt2ObjectMap<Object>(count / 10);
            HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>(count / 10);
            int[] obs = new int[count];
            map.put(0, "Hallo");
            System.out.println(map.get(0));
            for (int i3 = 0; i3 < count; ++i3) {
                obs[i3] = i3;
            }
            long tim = System.currentTimeMillis();
            for (i2 = 0; i2 < count; ++i2) {
                map.put(obs[i2], i2);
            }
            System.out.println("fst " + (System.currentTimeMillis() - tim));
            System.out.println(map.get(0));
            tim = System.currentTimeMillis();
            for (i2 = 0; i2 < count; ++i2) {
                hm.put(obs[i2], i2);
            }
            System.out.println("hmap " + (System.currentTimeMillis() - tim));
            tim = System.currentTimeMillis();
            for (j = 0; j < 10; ++j) {
                for (i = 0; i < count; ++i) {
                    if (!map.get(obs[i]).equals(i)) {
                        System.out.println("bug " + i);
                    }
                    if (map.get(i) != null) continue;
                    System.out.println("bug " + i);
                }
            }
            System.out.println("h" + hit + " m " + miss);
            System.out.println("fst read " + (System.currentTimeMillis() - tim));
            tim = System.currentTimeMillis();
            for (j = 0; j < 10; ++j) {
                for (i = 0; i < count; ++i) {
                    if ((Integer)hm.get(obs[i]) == i) continue;
                    System.out.println("bug " + i);
                }
            }
            System.out.println("hmap read " + (System.currentTimeMillis() - tim));
        }
    }

    public void dump() {
        for (int i = 0; i < this.mKeys.length; ++i) {
            int mKey = this.mKeys[i];
            if (mKey <= 0) continue;
            System.out.println("" + mKey + " => " + this.mValues[i]);
        }
        if (this.next != null) {
            this.next.dump();
        }
    }
}

