/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.ServerVersion;
import dev.miku.r2dbc.mysql.client.DefaultHostnameVerifier;
import dev.miku.r2dbc.mysql.client.SslState;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.message.server.SyntheticSslResponseMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.net.InetSocketAddress;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.tcp.SslProvider;

final class SslBridgeHandler
extends ChannelDuplexHandler {
    static final String NAME = "R2dbcMySqlSslBridgeHandler";
    private static final String SSL_NAME = "R2dbcMySqlSslHandler";
    private static final Logger logger = LoggerFactory.getLogger(SslBridgeHandler.class);
    private static final ServerVersion TLS1_2_COMMUNITY_VER = ServerVersion.create(8, 0, 4);
    private static final ServerVersion TLS1_2_ENTERPRISE_VER = ServerVersion.create(5, 6, 0);
    private final ConnectionContext context;
    private final MySqlSslConfiguration ssl;
    private SSLEngine sslEngine;

    SslBridgeHandler(ConnectionContext context, MySqlSslConfiguration ssl) {
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
        this.ssl = AssertUtils.requireNonNull(ssl, "ssl must not be null");
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.ssl.getSslMode() == SslMode.TUNNEL) {
            this.handleSslState(ctx, SslState.BRIDGING);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslState) {
            this.handleSslState(ctx, (SslState)((Object)evt));
            return;
        }
        if (evt instanceof SslHandshakeCompletionEvent) {
            this.handleSslCompleted(ctx, (SslHandshakeCompletionEvent)evt);
        }
        super.userEventTriggered(ctx, evt);
    }

    private void handleSslCompleted(ChannelHandlerContext ctx, SslHandshakeCompletionEvent evt) {
        if (!evt.isSuccess()) {
            ctx.fireExceptionCaught(evt.cause());
            return;
        }
        SslMode mode = this.ssl.getSslMode();
        if (mode.verifyIdentity()) {
            SSLEngine sslEngine = this.sslEngine;
            if (sslEngine == null) {
                ctx.fireExceptionCaught((Throwable)new IllegalStateException("sslEngine must not be null when verify identity"));
                return;
            }
            String host = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName();
            if (!this.hostnameVerifier().verify(host, sslEngine.getSession())) {
                ctx.fireExceptionCaught((Throwable)new SSLException("The hostname '" + host + "' could not be verified"));
                return;
            }
        }
        if (mode != SslMode.TUNNEL) {
            ctx.fireChannelRead((Object)SyntheticSslResponseMessage.getInstance());
        }
        logger.debug("SSL handshake completed, remove SSL bridge in pipeline");
        ctx.pipeline().remove(NAME);
    }

    private void handleSslState(ChannelHandlerContext ctx, SslState state) {
        switch (state) {
            case BRIDGING: {
                logger.debug("SSL event triggered, enable SSL handler to pipeline");
                SslProvider sslProvider = SslBridgeHandler.buildProvider(this.ssl, this.context.getServerVersion());
                SslHandler sslHandler = sslProvider.getSslContext().newHandler(ctx.alloc());
                this.sslEngine = sslHandler.engine();
                ctx.pipeline().addBefore(NAME, SSL_NAME, (ChannelHandler)sslHandler);
                break;
            }
            case UNSUPPORTED: {
                logger.debug("Server unsupported SSL, remove SSL bridge in pipeline");
                ctx.pipeline().remove(NAME);
            }
        }
    }

    private HostnameVerifier hostnameVerifier() {
        HostnameVerifier verifier = this.ssl.getSslHostnameVerifier();
        return verifier == null ? DefaultHostnameVerifier.INSTANCE : verifier;
    }

    private static SslProvider buildProvider(MySqlSslConfiguration ssl, ServerVersion version) {
        return SslProvider.builder().sslContext(SslBridgeHandler.buildContext(ssl, version)).defaultConfiguration(SslProvider.DefaultConfigurationType.TCP).build();
    }

    private static SslContextBuilder buildContext(MySqlSslConfiguration ssl, ServerVersion version) {
        SslContextBuilder builder = SslBridgeHandler.withTlsVersion(SslContextBuilder.forClient(), ssl, version);
        String sslKey = ssl.getSslKey();
        if (sslKey != null) {
            CharSequence keyPassword = ssl.getSslKeyPassword();
            String sslCert = ssl.getSslCert();
            if (sslCert == null) {
                throw new IllegalStateException("SSL key param requires but SSL cert param to be present");
            }
            builder.keyManager(new File(sslCert), new File(sslKey), keyPassword == null ? null : keyPassword.toString());
        }
        if (ssl.getSslMode().verifyCertificate()) {
            String sslCa = ssl.getSslCa();
            if (sslCa != null) {
                builder.trustManager(new File(sslCa));
            }
        } else {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        return ssl.customizeSslContext(builder);
    }

    private static SslContextBuilder withTlsVersion(SslContextBuilder builder, MySqlSslConfiguration ssl, ServerVersion version) {
        String[] tlsProtocols = ssl.getTlsVersion();
        if (tlsProtocols.length > 0) {
            builder.protocols(tlsProtocols);
        } else if (SslBridgeHandler.isEnabledTls1_2(version)) {
            builder.protocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"});
        } else {
            builder.protocols(new String[]{"TLSv1.1", "TLSv1"});
        }
        return builder;
    }

    private static boolean isEnabledTls1_2(ServerVersion version) {
        return version.isGreaterThanOrEqualTo(TLS1_2_COMMUNITY_VER) || version.isGreaterThanOrEqualTo(TLS1_2_ENTERPRISE_VER) && version.isEnterprise();
    }
}

