/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.GAV;
import fr.brouillard.oss.jgitver.JGitverModelProcessor;
import fr.brouillard.oss.jgitver.JGitverModelProcessorWorkingConfiguration;
import fr.brouillard.oss.jgitver.JGitverUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="jgitver")
public class JGitverExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ModelProcessor modelProcessor;

    public void afterProjectsRead(MavenSession mavenSession) throws MavenExecutionException {
        MavenProject rootProject = mavenSession.getTopLevelProject();
        List<MavenProject> projects = this.locateProjects(mavenSession, rootProject.getModules());
        Map<Object, Object> newProjectVersions = new LinkedHashMap();
        if (JGitverModelProcessor.class.isAssignableFrom(this.modelProcessor.getClass())) {
            JGitverModelProcessor jGitverModelProcessor = (JGitverModelProcessor)((Object)JGitverModelProcessor.class.cast(this.modelProcessor));
            JGitverModelProcessorWorkingConfiguration workingConfiguration = jGitverModelProcessor.getWorkingConfiguration();
            if (workingConfiguration == null) {
                this.logger.warn("");
                this.logger.warn("jgitver has changed!");
                this.logger.warn("");
                this.logger.warn("it now requires the usage of maven core extensions instead of standard plugin extensions.");
                this.logger.warn("The plugin must be now declared in a `.mvn/extensions.xml` file.");
                this.logger.warn("");
                this.logger.warn("    read https://github.com/jgitver/jgitver-maven-plugin for further information");
                this.logger.warn("");
                throw new MavenExecutionException("detection of jgitver old setting mechanism", (Throwable)new IllegalStateException("jgitver must now use maven core extensions"));
            }
            newProjectVersions = workingConfiguration.getNewProjectVersions();
        } else {
            this.logger.info("jgitver-maven-plugin is about to change project(s) version(s)");
            String newVersion = null;
            try {
                newVersion = JGitverUtils.calculateVersionForProject(rootProject, mavenSession.getUserProperties(), this.logger).getCalculatedVersion();
            }
            catch (IOException ex) {
                throw new MavenExecutionException("failure calculating version from git information", (Throwable)ex);
            }
            for (MavenProject project : projects) {
                GAV projectGAV = GAV.from(project);
                this.logger.debug("about to change in memory POM for: " + projectGAV);
                project.setVersion(newVersion);
                this.logger.debug("    version set to " + newVersion);
                VersionRange newVersionRange = VersionRange.createFromVersion((String)newVersion);
                project.getArtifact().setVersionRange(newVersionRange);
                this.logger.debug("    artifact version range set to " + newVersionRange);
                newProjectVersions.put(projectGAV, newVersion);
            }
            try {
                JGitverUtils.attachModifiedPomFilesToTheProject(projects, newProjectVersions, mavenSession, this.logger);
            }
            catch (IOException | XmlPullParserException ex) {
                throw new MavenExecutionException("cannot attach updated POMs during project execution", ex);
            }
        }
        newProjectVersions.entrySet().forEach(e -> this.logger.info("    " + ((GAV)e.getKey()).toString() + " -> " + (String)e.getValue()));
    }

    private List<MavenProject> locateProjects(MavenSession session, List<String> modules) {
        List projects = session.getProjects();
        List allProjects = null;
        boolean multiModule = modules != null && modules.size() > 0;
        try {
            allProjects = session.getAllProjects();
            if (allProjects != null) {
                projects = allProjects;
            }
        }
        catch (Throwable error) {
            if (error instanceof NoSuchMethodError || error instanceof NoSuchMethodException) {
                this.logger.warn("your maven version is <= 3.2.0 ; you should upgrade to enable jgitver-maven-plugin full integration");
            }
            throw error;
        }
        if (allProjects == null && multiModule) {
            this.logger.warn("maven object model partially initialized, jgitver-maven-plugin will use filtered list of maven projects in case reactor was filtered with -pl");
        }
        return projects;
    }
}

