/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.BranchingPolicy;
import fr.brouillard.oss.jgitver.GAV;
import fr.brouillard.oss.jgitver.GitVersionCalculator;
import fr.brouillard.oss.jgitver.JGitverConfiguration;
import fr.brouillard.oss.jgitver.JGitverModelProcessorWorkingConfiguration;
import fr.brouillard.oss.jgitver.JGitverUtils;
import fr.brouillard.oss.jgitver.JGitverVersion;
import fr.brouillard.oss.jgitver.cfg.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=ModelProcessor.class)
public class JGitverModelProcessor
extends DefaultModelProcessor {
    @Requirement
    private Logger logger = null;
    @Requirement
    private LegacySupport legacySupport = null;
    @Requirement
    private JGitverConfiguration configurationProvider;
    private volatile JGitverModelProcessorWorkingConfiguration workingConfiguration;

    public JGitverModelProcessorWorkingConfiguration getWorkingConfiguration() {
        return this.workingConfiguration;
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateVersionIfNecessary() throws Exception {
        if (this.workingConfiguration == null) {
            JGitverModelProcessor jGitverModelProcessor = this;
            synchronized (jGitverModelProcessor) {
                if (this.workingConfiguration == null) {
                    this.logger.info("jgitver-maven-plugin is about to change project(s) version(s)");
                    MavenSession mavenSession = this.legacySupport.getSession();
                    File rootDirectory = mavenSession.getRequest().getMultiModuleProjectDirectory();
                    this.logger.debug("using jgitver on directory: " + rootDirectory);
                    Configuration cfg = this.configurationProvider.getConfiguration();
                    try (GitVersionCalculator gitVersionCalculator = GitVersionCalculator.location((File)rootDirectory);){
                        gitVersionCalculator.setMavenLike(cfg.mavenLike).setAutoIncrementPatch(cfg.autoIncrementPatch).setUseDirty(cfg.useDirty).setUseDistance(cfg.useCommitDistance).setUseGitCommitId(cfg.useGitCommitId).setGitCommitIdLength(cfg.gitCommitIdLength).setUseDefaultBranchingPolicy(cfg.useDefaultBranchingPolicy).setNonQualifierBranches(cfg.nonQualifierBranches);
                        if (cfg.regexVersionTag != null) {
                            gitVersionCalculator.setFindTagVersionPattern(cfg.regexVersionTag);
                        }
                        if (cfg.branchPolicies != null && !cfg.branchPolicies.isEmpty()) {
                            List policies = cfg.branchPolicies.stream().map(bp -> new BranchingPolicy(bp.pattern, bp.transformations)).collect(Collectors.toList());
                            gitVersionCalculator.setQualifierBranchingPolicies(policies);
                        }
                        JGitverVersion jGitverVersion = new JGitverVersion(gitVersionCalculator);
                        JGitverUtils.fillPropertiesFromMetadatas(mavenSession.getUserProperties(), jGitverVersion, this.logger);
                        this.workingConfiguration = new JGitverModelProcessorWorkingConfiguration(jGitverVersion.getCalculatedVersion(), rootDirectory);
                    }
                }
            }
        }
    }

    private Model provisionModel(Model model, Map<String, ?> options) throws IOException {
        try {
            this.calculateVersionIfNecessary();
        }
        catch (Exception ex) {
            this.logger.error("failure while calculating version", (Throwable)ex);
            throw new IOException("cannot build a Model object using jgitver", ex);
        }
        Source source = (Source)options.get("org.apache.maven.model.building.source");
        if (source == null) {
            return model;
        }
        File location = new File(source.getLocation());
        if (!location.isFile()) {
            return model;
        }
        if (this.configurationProvider.ignore(location)) {
            this.logger.debug("file " + location + " ignored by configuration");
            return model;
        }
        File relativePath = location.getParentFile().getCanonicalFile();
        if (StringUtils.containsIgnoreCase((CharSequence)relativePath.getCanonicalPath(), (CharSequence)this.workingConfiguration.getMultiModuleProjectDirectory().getCanonicalPath())) {
            File relativePathParent;
            this.logger.debug("handling version of project Model from " + location);
            this.workingConfiguration.getNewProjectVersions().put(GAV.from(model.clone()), this.workingConfiguration.getCalculatedVersion());
            if (Objects.nonNull(model.getVersion())) {
                model.setVersion(this.workingConfiguration.getCalculatedVersion());
            }
            if (Objects.nonNull(model.getParent()) && StringUtils.containsIgnoreCase((CharSequence)(relativePathParent = new File(relativePath.getCanonicalPath() + File.separator + model.getParent().getRelativePath()).getParentFile().getCanonicalFile()).getCanonicalPath(), (CharSequence)this.workingConfiguration.getMultiModuleProjectDirectory().getCanonicalPath())) {
                model.getParent().setVersion(this.workingConfiguration.getCalculatedVersion());
            }
            if (relativePath.getCanonicalPath().equals(this.workingConfiguration.getMultiModuleProjectDirectory().getCanonicalPath())) {
                Optional<PluginExecution> pluginExecutionOptional;
                PluginExecution pluginExecution;
                if (Objects.isNull(model.getBuild())) {
                    model.setBuild(new Build());
                }
                if (Objects.isNull(model.getBuild().getPlugins())) {
                    model.getBuild().setPlugins(new ArrayList());
                }
                Optional<Plugin> pluginOptional = model.getBuild().getPlugins().stream().filter(x -> "fr.brouillard.oss".equalsIgnoreCase(x.getGroupId()) && "jgitver-maven-plugin".equalsIgnoreCase(x.getArtifactId())).findFirst();
                StringBuilder pluginVersion = new StringBuilder();
                try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/fr.brouillard.oss/jgitver-maven-plugin/pom.properties");){
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    pluginVersion.append(properties.getProperty("version"));
                }
                catch (IOException ignored) {
                    this.logger.warn(ignored.getMessage(), (Throwable)ignored);
                }
                Plugin plugin = pluginOptional.orElseGet(() -> {
                    Plugin plugin2 = new Plugin();
                    plugin2.setGroupId("fr.brouillard.oss");
                    plugin2.setArtifactId("jgitver-maven-plugin");
                    plugin2.setVersion(pluginVersion.toString());
                    model.getBuild().getPlugins().add(plugin2);
                    return plugin2;
                });
                if (Objects.isNull(plugin.getExecutions())) {
                    plugin.setExecutions(new ArrayList());
                }
                if (Objects.isNull((pluginExecution = (pluginExecutionOptional = plugin.getExecutions().stream().filter(x -> "verify".equalsIgnoreCase(x.getPhase())).findFirst()).orElseGet(() -> {
                    PluginExecution pluginExecution2 = new PluginExecution();
                    pluginExecution2.setPhase("verify");
                    plugin.getExecutions().add(pluginExecution2);
                    return pluginExecution2;
                })).getGoals())) {
                    pluginExecution.setGoals(new ArrayList());
                }
                if (!pluginExecution.getGoals().contains("attach-modified-poms")) {
                    pluginExecution.getGoals().add("attach-modified-poms");
                }
                if (Objects.isNull(plugin.getDependencies())) {
                    plugin.setDependencies(new ArrayList());
                }
                Optional<Dependency> dependencyOptional = plugin.getDependencies().stream().filter(x -> "fr.brouillard.oss".equalsIgnoreCase(x.getGroupId()) && "jgitver-maven-plugin".equalsIgnoreCase(x.getArtifactId())).findFirst();
                dependencyOptional.orElseGet(() -> {
                    Dependency dependency = new Dependency();
                    dependency.setGroupId("fr.brouillard.oss");
                    dependency.setArtifactId("jgitver-maven-plugin");
                    dependency.setVersion(pluginVersion.toString());
                    plugin.getDependencies().add(dependency);
                    return dependency;
                });
            }
            try {
                this.legacySupport.getSession().getUserProperties().put(JGitverModelProcessorWorkingConfiguration.class.getName(), JGitverModelProcessorWorkingConfiguration.serializeTo(this.workingConfiguration));
            }
            catch (JAXBException ex) {
                throw new IOException("unexpected Model serialization issue", ex);
            }
        }
        this.logger.debug("skipping Model from " + location);
        return model;
    }
}

