/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.GAV;
import fr.brouillard.oss.jgitver.GitVersionCalculator;
import fr.brouillard.oss.jgitver.JGitverPluginConfiguration;
import fr.brouillard.oss.jgitver.JGitverVersion;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class JGitverUtils {
    public static final String EXTENSION_PREFIX = "jgitver";
    public static final String EXTENSION_GROUP_ID = "fr.brouillard.oss";
    public static final String EXTENSION_ARTIFACT_ID = "jgitver-maven-plugin";

    private JGitverUtils() {
    }

    public static Model loadInitialModel(File pomFile) throws IOException, XmlPullParserException {
        try (FileReader fileReader = new FileReader(pomFile);){
            Model model = new MavenXpp3Reader().read((Reader)fileReader);
            return model;
        }
    }

    public static File createPomDumpFile() throws IOException {
        File tmp = File.createTempFile("pom", ".jgitver-maven-plugin.xml");
        tmp.deleteOnExit();
        return tmp;
    }

    public static void writeModelPom(Model mavenModel, File pomFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(pomFile);){
            new MavenXpp3Writer().write((Writer)fileWriter, mavenModel);
        }
    }

    public static void changeBaseDir(MavenProject project, File initialBaseDir) throws NoSuchFieldException, IllegalAccessException {
        Field basedirField = project.getClass().getField("basedir");
        basedirField.setAccessible(true);
        basedirField.set(project, initialBaseDir);
    }

    public static void setProjectPomFile(MavenProject project, File newPom, Logger logger) {
        try {
            project.setPomFile(newPom);
        }
        catch (Throwable unused) {
            logger.warn("maven version might be <= 3.2.4, changing pom file using old mechanism");
            File initialBaseDir = project.getBasedir();
            project.setFile(newPom);
            File newBaseDir = project.getBasedir();
            try {
                if (!initialBaseDir.getCanonicalPath().equals(newBaseDir.getCanonicalPath())) {
                    JGitverUtils.changeBaseDir(project, initialBaseDir);
                }
            }
            catch (Exception ex) {
                GAV gav = GAV.from(project);
                logger.warn("cannot reset basedir of project " + gav.toString(), (Throwable)ex);
            }
        }
    }

    public static void fillPropertiesFromMetadatas(Properties properties, JGitverVersion jgitverVersion, Logger logger) {
        logger.debug("jgitver calculated version number: " + jgitverVersion.getCalculatedVersion());
        properties.put("jgitver.calculated_version", jgitverVersion.getCalculatedVersion());
        Arrays.asList(Metadatas.values()).stream().forEach(metaData -> {
            Optional metaValue = jgitverVersion.getGitVersionCalculator().meta(metaData);
            String propertyName = "jgitver." + metaData.name().toLowerCase(Locale.ENGLISH);
            String value = metaValue.orElse("");
            properties.put(propertyName, value);
            logger.debug("setting property " + propertyName + " with \"" + value + "\"");
        });
    }

    public static JGitverVersion calculateVersionForProject(MavenProject rootProject, Properties properties, Logger logger) throws IOException {
        JGitverVersion jGitverVersion = null;
        logger.debug("using jgitver on directory: " + rootProject.getBasedir());
        try (GitVersionCalculator gitVersionCalculator = GitVersionCalculator.location((File)rootProject.getBasedir());){
            Plugin plugin = rootProject.getPlugin("fr.brouillard.oss:jgitver-maven-plugin");
            JGitverPluginConfiguration pluginConfig = new JGitverPluginConfiguration(Optional.ofNullable(plugin).map(ConfigurationContainer::getConfiguration).map(Xpp3Dom.class::cast));
            gitVersionCalculator.setMavenLike(pluginConfig.mavenLike()).setAutoIncrementPatch(pluginConfig.autoIncrementPatch()).setUseDistance(pluginConfig.useCommitDistance()).setUseGitCommitId(pluginConfig.useGitCommitId()).setGitCommitIdLength(pluginConfig.gitCommitIdLength()).setUseDirty(pluginConfig.useDirty()).setNonQualifierBranches(pluginConfig.nonQualifierBranches().stream().collect(Collectors.joining(",")));
            jGitverVersion = new JGitverVersion(gitVersionCalculator);
            JGitverUtils.fillPropertiesFromMetadatas(properties, jGitverVersion, logger);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        return jGitverVersion;
    }

    public static void attachModifiedPomFilesToTheProject(List<MavenProject> projects, Map<GAV, String> newProjectVersions, MavenSession mavenSession, Logger logger) throws IOException, XmlPullParserException {
        for (MavenProject project : projects) {
            Model model = JGitverUtils.loadInitialModel(project.getFile());
            GAV initalProjectGAV = GAV.from(model);
            logger.debug("about to change file pom for: " + initalProjectGAV);
            if (newProjectVersions.containsKey(initalProjectGAV)) {
                model.setVersion(newProjectVersions.get(initalProjectGAV));
            }
            if (model.getParent() != null) {
                GAV parentGAV = GAV.from(model.getParent());
                if (newProjectVersions.keySet().contains(parentGAV)) {
                    model.getParent().setVersion(newProjectVersions.get(parentGAV));
                }
            }
            File newPom = JGitverUtils.createPomDumpFile();
            JGitverUtils.writeModelPom(model, newPom);
            logger.debug("    new pom file created for " + initalProjectGAV + " under " + newPom);
            JGitverUtils.setProjectPomFile(project, newPom, logger);
            logger.debug("    pom file set");
        }
    }
}

