/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.snippets;

import cucumber.runtime.snippets.FunctionNameSanitizer;

public class UnderscoreFunctionNameSanitizer
implements FunctionNameSanitizer {
    private static final Character SUBST = Character.valueOf('_');

    @Override
    public String sanitizeFunctionName(String functionName) {
        StringBuilder sanitized = new StringBuilder();
        String trimmedFunctionName = functionName.trim();
        sanitized.append(Character.isJavaIdentifierStart(trimmedFunctionName.charAt(0)) ? trimmedFunctionName.charAt(0) : SUBST.charValue());
        for (int i = 1; i < trimmedFunctionName.length(); ++i) {
            if (Character.isJavaIdentifierPart(trimmedFunctionName.charAt(i))) {
                sanitized.append(trimmedFunctionName.charAt(i));
                continue;
            }
            if (sanitized.charAt(sanitized.length() - 1) == SUBST.charValue() || i == trimmedFunctionName.length() - 1) continue;
            sanitized.append(SUBST);
        }
        return sanitized.toString();
    }
}

