/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.http;

import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import io.github.quickmsg.common.utils.JacksonUtil;
import io.github.quickmsg.http.HttpParam;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfig;

public class HttpSourceBean
implements SourceBean {
    private static final Logger log = LoggerFactory.getLogger(HttpSourceBean.class);
    private HttpParam httpParam;
    private HttpClient httpClient;

    public Boolean support(Source source) {
        return source == Source.HTTP;
    }

    public Boolean bootstrap(Map<String, Object> sourceParam) {
        this.httpParam = new HttpParam();
        this.httpParam.setUrl(String.valueOf(sourceParam.get("url")));
        this.httpParam.setHeaders((Map)sourceParam.get("headers"));
        this.httpParam.setAdditions((Map)sourceParam.get("additions"));
        this.httpClient = HttpClient.create().headers(heads -> {
            this.httpParam.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)heads).add(arg_0, arg_1));
            heads.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
        });
        return true;
    }

    public void transmit(Object object) {
        ((HttpClient.RequestSender)this.httpClient.post().uri(this.httpParam.getUrl())).send((Publisher)Mono.just((Object)PooledByteBufAllocator.DEFAULT.directBuffer().writeBytes(JacksonUtil.dynamicJson((Object)object).getBytes()))).response().log().subscribe();
    }

    public void close() {
        ((HttpClientConfig)this.httpClient.configuration()).connectionProvider().dispose();
    }
}

