/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Reader;
import io.helidon.common.reactive.Flow;
import io.helidon.media.common.CharBuffer;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.jackson.common.JacksonRuntimeException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;

public final class JacksonProcessing {
    private JacksonProcessing() {
    }

    public static Reader<Object> reader(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return (publisher, cls) -> ContentReaders.byteArrayReader().apply(publisher).thenApply(bytes -> {
            try {
                return objectMapper.readValue(bytes, cls);
            }
            catch (IOException wrapMe) {
                throw new JacksonRuntimeException(wrapMe.getMessage(), wrapMe);
            }
        });
    }

    public static Function<Object, Flow.Publisher<DataChunk>> writer(ObjectMapper objectMapper, Charset charset) {
        Objects.requireNonNull(objectMapper);
        return payload -> {
            CharBuffer buffer = new CharBuffer();
            try {
                objectMapper.writeValue((Writer)buffer, payload);
            }
            catch (IOException wrapMe) {
                throw new JacksonRuntimeException(wrapMe.getMessage(), wrapMe);
            }
            return (Flow.Publisher)ContentWriters.charBufferWriter((Charset)(charset == null ? StandardCharsets.UTF_8 : charset)).apply(buffer);
        };
    }
}

