/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.util.ConfigPersister;
import io.kubernetes.client.util.authenticators.Authenticator;
import io.kubernetes.client.util.authenticators.AzureActiveDirectoryAuthenticator;
import io.kubernetes.client.util.authenticators.GCPAuthenticator;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class KubeConfig {
    private static final Logger log = LoggerFactory.getLogger(KubeConfig.class);
    public static final String ENV_HOME = "HOME";
    public static final String KUBEDIR = ".kube";
    public static final String KUBECONFIG = "config";
    private static Map<String, Authenticator> authenticators = new HashMap<String, Authenticator>();
    private ArrayList<Object> clusters;
    private ArrayList<Object> contexts;
    private ArrayList<Object> users;
    String currentContextName;
    Map<String, Object> currentContext;
    Map<String, Object> currentCluster;
    Map<String, Object> currentUser;
    String currentNamespace;
    Object preferences;
    ConfigPersister persister;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthenticator(Authenticator auth) {
        Map<String, Authenticator> map = authenticators;
        synchronized (map) {
            authenticators.put(auth.getName(), auth);
        }
    }

    public static KubeConfig loadKubeConfig(Reader input) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Object config = yaml.load(input);
        Map configMap = (Map)config;
        String currentContext = (String)configMap.get("current-context");
        ArrayList contexts = (ArrayList)configMap.get("contexts");
        ArrayList clusters = (ArrayList)configMap.get("clusters");
        ArrayList users = (ArrayList)configMap.get("users");
        Object preferences = configMap.get("preferences");
        KubeConfig kubeConfig = new KubeConfig(contexts, clusters, users);
        kubeConfig.setContext(currentContext);
        kubeConfig.setPreferences(preferences);
        return kubeConfig;
    }

    public KubeConfig(ArrayList<Object> contexts, ArrayList<Object> clusters, ArrayList<Object> users) {
        this.contexts = contexts;
        this.clusters = clusters;
        this.users = users;
    }

    public String getCurrentContext() {
        return this.currentContextName;
    }

    public boolean setContext(String context) {
        Map<String, Object> obj;
        if (context == null) {
            return false;
        }
        this.currentContextName = context;
        this.currentCluster = null;
        this.currentUser = null;
        Map<String, Object> ctx = KubeConfig.findObject(this.contexts, context);
        if (ctx == null) {
            return false;
        }
        this.currentContext = (Map)ctx.get("context");
        if (this.currentContext == null) {
            return false;
        }
        String cluster = (String)this.currentContext.get("cluster");
        String user = (String)this.currentContext.get("user");
        this.currentNamespace = (String)this.currentContext.get("namespace");
        if (cluster != null && (obj = KubeConfig.findObject(this.clusters, cluster)) != null) {
            this.currentCluster = (Map)obj.get("cluster");
        }
        if (user != null && (obj = KubeConfig.findObject(this.users, user)) != null) {
            this.currentUser = (Map)obj.get("user");
        }
        return true;
    }

    public ArrayList<Object> getContexts() {
        return this.contexts;
    }

    public ArrayList<Object> getClusters() {
        return this.clusters;
    }

    public ArrayList<Object> getUsers() {
        return this.users;
    }

    public String getNamespace() {
        return this.currentNamespace;
    }

    public Object getPreferences() {
        return this.preferences;
    }

    public String getServer() {
        return KubeConfig.getData(this.currentCluster, "server");
    }

    public String getCertificateAuthorityData() {
        return KubeConfig.getData(this.currentCluster, "certificate-authority-data");
    }

    public String getCertificateAuthorityFile() {
        return KubeConfig.getData(this.currentCluster, "certificate-authority");
    }

    public String getClientCertificateFile() {
        return KubeConfig.getData(this.currentUser, "client-certificate");
    }

    public String getClientCertificateData() {
        return KubeConfig.getData(this.currentUser, "client-certificate-data");
    }

    public String getClientKeyFile() {
        return KubeConfig.getData(this.currentUser, "client-key");
    }

    public String getClientKeyData() {
        return KubeConfig.getData(this.currentUser, "client-key-data");
    }

    public String getUsername() {
        return KubeConfig.getData(this.currentUser, "username");
    }

    public String getPassword() {
        return KubeConfig.getData(this.currentUser, "password");
    }

    public String getAccessToken() {
        Map authProviderMap;
        Map<String, Object> authConfig;
        if (this.currentUser == null) {
            return null;
        }
        Object authProvider = this.currentUser.get("auth-provider");
        if (authProvider != null && (authConfig = (Map<String, Object>)(authProviderMap = (Map)authProvider).get(KUBECONFIG)) != null) {
            String name = (String)authProviderMap.get("name");
            Authenticator auth = authenticators.get(name);
            if (auth != null) {
                if (auth.isExpired(authConfig)) {
                    authConfig = auth.refresh(authConfig);
                    if (this.persister != null) {
                        try {
                            this.persister.save(this.contexts, this.clusters, this.users, this.preferences, this.currentContextName);
                        }
                        catch (IOException ex) {
                            log.error("Failed to persist new token", (Throwable)ex);
                        }
                    }
                }
                return auth.getToken(authConfig);
            }
            log.error("Unknown auth provider: " + name);
        }
        if (this.currentUser.containsKey("token")) {
            return (String)this.currentUser.get("token");
        }
        if (this.currentUser.containsKey("tokenFile")) {
            String tokenFile = (String)this.currentUser.get("tokenFile");
            try {
                byte[] data = Files.readAllBytes(FileSystems.getDefault().getPath(tokenFile, new String[0]));
                return new String(data, StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                log.error("Failed to read token file", (Throwable)ex);
            }
        }
        return null;
    }

    public boolean verifySSL() {
        if (this.currentCluster == null) {
            return false;
        }
        if (this.currentCluster.containsKey("insecure-skip-tls-verify")) {
            return (Boolean)this.currentCluster.get("insecure-skip-tls-verify") == false;
        }
        return true;
    }

    public void setPersistConfig(ConfigPersister persister) {
        this.persister = persister;
    }

    public void setPreferences(Object preferences) {
        this.preferences = preferences;
    }

    private static String getData(Map<String, Object> obj, String key) {
        if (obj == null) {
            return null;
        }
        return (String)obj.get(key);
    }

    private static Map<String, Object> findObject(ArrayList<Object> list, String name) {
        if (list == null) {
            return null;
        }
        for (Object obj : list) {
            Map map = (Map)obj;
            if (!name.equals(map.get("name"))) continue;
            return map;
        }
        return null;
    }

    public static byte[] getDataOrFile(String data, String file) throws IOException {
        if (data != null) {
            return Base64.decodeBase64((String)data);
        }
        if (file != null) {
            return Files.readAllBytes(Paths.get(file, new String[0]));
        }
        return null;
    }

    static {
        KubeConfig.registerAuthenticator(new GCPAuthenticator());
        KubeConfig.registerAuthenticator(new AzureActiveDirectoryAuthenticator());
    }
}

