/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.lang.Nullable;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontNamingConvention;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("wavefront-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(WavefrontMeterRegistry.class);
    private final WavefrontConfig config;
    private final HttpSender httpClient;

    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    @Deprecated
    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory) {
        this(config, clock, threadFactory, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.httpClient = httpClient;
        if (this.directToApi() && config.apiToken() == null) {
            throw new MissingRequiredConfigurationException("apiToken must be set whenever publishing directly to the Wavefront API");
        }
        this.config().namingConvention((NamingConvention)new WavefrontNamingConvention(config.globalPrefix()));
        this.start(threadFactory);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to wavefront every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected void publish() {
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            Stream<String> stream = batch.stream().flatMap(m -> (Stream)m.match(this::writeMeter, this::writeMeter, this::writeTimer, this::writeSummary, this::writeMeter, this::writeMeter, this::writeMeter, this::writeFunctionTimer, this::writeMeter));
            if (this.directToApi()) {
                try {
                    this.httpClient.post(this.config.uri() + "/report/metrics?t=" + this.config.apiToken() + "&h=" + this.config.source()).acceptJson().withJsonContent("{" + stream.collect(Collectors.joining(",")) + "}").send().onSuccess(response -> this.logSuccessfulMetricsSent(batch)).onError(response -> this.logger.error("failed to send metrics to wavefront: {}", (Object)response.body()));
                }
                catch (Throwable e) {
                    this.logger.error("failed to send metrics to wavefront", e);
                }
                continue;
            }
            URI uri = URI.create(this.config.uri());
            try {
                InetSocketAddress endpoint = uri.getHost() != null ? new InetSocketAddress(uri.getHost(), uri.getPort()) : new InetSocketAddress(InetAddress.getByName(null), uri.getPort());
                try {
                    Socket socket = new Socket();
                    Throwable throwable = null;
                    try {
                        socket.connect(endpoint, (int)this.config.connectTimeout().toMillis());
                        try (OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8);){
                            writer.write(stream.collect(Collectors.joining("\n")) + "\n");
                            writer.flush();
                        }
                        this.logSuccessfulMetricsSent(batch);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (socket == null) continue;
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        socket.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("failed to send metrics to wavefront", (Throwable)e);
                }
            }
            catch (UnknownHostException e) {
                this.logger.error("failed to send metrics to wavefront: unknown host + " + uri.getHost());
            }
        }
    }

    private void logSuccessfulMetricsSent(List<Meter> batch) {
        this.logger.debug("successfully sent {} metrics to Wavefront.", (Object)batch.size());
    }

    private boolean directToApi() {
        return !"proxy".equals(URI.create(this.config.uri()).getScheme());
    }

    private Stream<String> writeFunctionTimer(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        this.addMetric(metrics, id, "count", wallTime, timer.count());
        this.addMetric(metrics, id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
        this.addMetric(metrics, id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
        return metrics.build();
    }

    private Stream<String> writeTimer(Timer timer) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        this.addMetric(metrics, id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
        this.addMetric(metrics, id, "count", wallTime, timer.count());
        this.addMetric(metrics, id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
        this.addMetric(metrics, id, "max", wallTime, timer.max(this.getBaseTimeUnit()));
        return metrics.build();
    }

    private Stream<String> writeSummary(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = summary.getId();
        this.addMetric(metrics, id, "sum", wallTime, summary.totalAmount());
        this.addMetric(metrics, id, "count", wallTime, summary.count());
        this.addMetric(metrics, id, "avg", wallTime, summary.mean());
        this.addMetric(metrics, id, "max", wallTime, summary.max());
        return metrics.build();
    }

    private Stream<String> writeMeter(Meter meter) {
        long wallTime = this.clock.wallTime();
        Stream.Builder metrics = Stream.builder();
        StreamSupport.stream(meter.measure().spliterator(), false).forEach(measurement -> {
            Meter.Id id = meter.getId().withTag(measurement.getStatistic());
            this.addMetric(metrics, id, null, wallTime, measurement.getValue());
        });
        return metrics.build();
    }

    void addMetric(Stream.Builder<String> metrics, Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        if (Double.isFinite(value)) {
            metrics.add(this.writeMetric(id, suffix, wallTime, value));
        }
    }

    private String writeMetric(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        return this.directToApi() ? this.writeMetricDirect(id, suffix, value) : this.writeMetricProxy(id, suffix, wallTime, value);
    }

    private String writeMetricProxy(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        return "\"" + this.getConventionName(fullId) + "\" " + DoubleFormat.decimalOrNan((double)value) + " " + wallTime / 1000L + " source=" + this.config.source() + " " + this.getConventionTags(fullId).stream().map(t -> t.getKey() + "=\"" + t.getValue() + "\"").collect(Collectors.joining(" "));
    }

    private String writeMetricDirect(Meter.Id id, @Nullable String suffix, double value) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        List conventionTags = this.getConventionTags(fullId);
        String tags = conventionTags.stream().map(t -> "\"" + StringEscapeUtils.escapeJson((String)t.getKey()) + "\": \"" + StringEscapeUtils.escapeJson((String)t.getValue()) + "\"").collect(Collectors.joining(","));
        UUID uuid = UUID.randomUUID();
        String uniqueNameSuffix = Long.valueOf(uuid.getMostSignificantBits()).toString() + uuid.getLeastSignificantBits();
        return "\"" + StringEscapeUtils.escapeJson((String)this.getConventionName(fullId)) + "$" + uniqueNameSuffix + "\": {\"value\": " + DoubleFormat.decimalOrNan((double)value) + ",\"tags\": {" + tags + "}}";
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return id.withName(id.getName() + "." + suffix);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    public static Builder builder(WavefrontConfig config) {
        return new Builder(config);
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final WavefrontConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = WavefrontMeterRegistry.access$000();
        private HttpSender httpClient;

        Builder(WavefrontConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public WavefrontMeterRegistry build() {
            return new WavefrontMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }
}

