/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramGauges;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.push.PushMeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.lang.Nullable;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontDistributionSummary;
import io.micrometer.wavefront.WavefrontMetricLineData;
import io.micrometer.wavefront.WavefrontNamingConvention;
import io.micrometer.wavefront.WavefrontTimer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("waveferont-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(WavefrontMeterRegistry.class);
    private final WavefrontConfig config;
    private final HttpSender httpClient;
    private final URI uri;
    private final int distributionPort;
    private final Set<HistogramGranularity> histogramGranularities;

    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    @Deprecated
    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory) {
        this(config, clock, threadFactory, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((PushRegistryConfig)config, clock);
        this.config = config;
        if (this.directToApi() && config.apiToken() == null) {
            throw new MissingRequiredConfigurationException("apiToken must be set whenever publishing directly to the Wavefront API");
        }
        this.httpClient = httpClient;
        this.uri = URI.create(config.uri());
        this.distributionPort = config.distributionPort();
        this.histogramGranularities = new HashSet<HistogramGranularity>();
        if (config.reportMinuteDistribution()) {
            this.histogramGranularities.add(HistogramGranularity.MINUTE);
        }
        if (config.reportHourDistribution()) {
            this.histogramGranularities.add(HistogramGranularity.HOUR);
        }
        if (config.reportDayDistribution()) {
            this.histogramGranularities.add(HistogramGranularity.DAY);
        }
        this.config().namingConvention((NamingConvention)new WavefrontNamingConvention(config.globalPrefix()));
        this.start(threadFactory);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to Wavefront every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new DefaultLongTaskTimer(id, this.clock);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        WavefrontTimer timer = new WavefrontTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit());
        if (!timer.isPublishingHistogram()) {
            HistogramGauges.registerWithCommonFormat((Timer)timer, (MeterRegistry)this);
        }
        return timer;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        WavefrontDistributionSummary summary = new WavefrontDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
        if (!summary.isPublishingHistogram()) {
            HistogramGauges.registerWithCommonFormat((DistributionSummary)summary, (MeterRegistry)this);
        }
        return summary;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new CumulativeFunctionCounter(id, obj, countFunction);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected void publish() {
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            Stream.Builder metrics = Stream.builder();
            Stream.Builder distributions = Stream.builder();
            AtomicInteger distributionCount = new AtomicInteger();
            batch.stream().flatMap(m -> (Stream)m.match(this::writeMeter, this::writeMeter, this::writeTimer, this::writeSummary, this::writeMeter, this::writeMeter, this::writeMeter, this::writeFunctionTimer, this::writeMeter)).forEach(metricLineData -> {
                if (metricLineData.isDistribution()) {
                    distributions.add(metricLineData.lineData());
                    distributionCount.getAndIncrement();
                } else {
                    metrics.add(metricLineData.lineData());
                }
            });
            Stream<String> metricStream = metrics.build();
            Stream<String> distributionStream = distributions.build();
            if (this.directToApi()) {
                this.flushDirectToApi(metricStream, "wavefront", "metrics", batch.size());
                this.flushDirectToApi(distributionStream, "histogram", "distributions", distributionCount.get());
                continue;
            }
            this.flushToProxy(metricStream, this.uri.getPort(), "metrics", batch.size());
            this.flushToProxy(distributionStream, this.distributionPort, "distributions", distributionCount.get());
        }
    }

    private void flushDirectToApi(Stream<String> stream, String format, String description, int count) {
        if (count == 0) {
            return;
        }
        try {
            String originalPath = this.uri.getPath() != null && !this.uri.getPath().equals("/") ? this.uri.getPath() : "";
            this.httpClient.post(new URL(this.uri.getScheme(), this.uri.getHost(), this.uri.getPort(), originalPath + "/report?f=" + format).toString()).withHeader("Authorization", "Bearer " + this.config.apiToken()).withContent("application/octet-stream", stream.collect(Collectors.joining())).compress().send().onSuccess(response -> this.logSuccessfulMetricsSent(description, count)).onError(response -> this.logger.error("failed to send {} to Wavefront: {}", (Object)description, (Object)response.body()));
        }
        catch (Throwable e) {
            this.logger.error("failed to send " + description + " to Wavefront", e);
        }
    }

    private void flushToProxy(Stream<String> stream, int port, String description, int count) {
        if (count == 0) {
            return;
        }
        try {
            InetSocketAddress endpoint = this.uri.getHost() != null ? new InetSocketAddress(this.uri.getHost(), port) : new InetSocketAddress(InetAddress.getByName(null), port);
            try (Socket socket = new Socket();){
                socket.connect(endpoint, (int)this.config.connectTimeout().toMillis());
                try (OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8);){
                    writer.write(stream.collect(Collectors.joining()));
                    writer.flush();
                }
                this.logSuccessfulMetricsSent(description, count);
            }
            catch (IOException e) {
                this.logger.error("failed to send " + description + " to Wavefront", (Throwable)e);
            }
        }
        catch (UnknownHostException e) {
            this.logger.error("failed to send " + description + " to Wavefront: unknown host " + this.uri.getHost());
        }
    }

    private void logSuccessfulMetricsSent(String description, int count) {
        this.logger.debug("successfully sent {} {} to Wavefront.", (Object)count, (Object)description);
    }

    private boolean directToApi() {
        return !"proxy".equals(URI.create(this.config.uri()).getScheme());
    }

    private Stream<WavefrontMetricLineData> writeFunctionTimer(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<WavefrontMetricLineData> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        this.addMetric(metrics, id, "count", wallTime, timer.count());
        this.addMetric(metrics, id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
        this.addMetric(metrics, id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
        return metrics.build();
    }

    private Stream<WavefrontMetricLineData> writeTimer(Timer timer) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<WavefrontMetricLineData> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        WavefrontTimer wfTimer = (WavefrontTimer)timer;
        if (wfTimer.isPublishingHistogram()) {
            this.addDistribution(metrics, id, wfTimer.flushDistributions());
        } else {
            this.addMetric(metrics, id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
            this.addMetric(metrics, id, "count", wallTime, timer.count());
            this.addMetric(metrics, id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
            this.addMetric(metrics, id, "max", wallTime, timer.max(this.getBaseTimeUnit()));
        }
        return metrics.build();
    }

    private Stream<WavefrontMetricLineData> writeSummary(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<WavefrontMetricLineData> metrics = Stream.builder();
        Meter.Id id = summary.getId();
        WavefrontDistributionSummary wfSummary = (WavefrontDistributionSummary)summary;
        if (wfSummary.isPublishingHistogram()) {
            this.addDistribution(metrics, id, wfSummary.flushDistributions());
        } else {
            this.addMetric(metrics, id, "sum", wallTime, summary.totalAmount());
            this.addMetric(metrics, id, "count", wallTime, summary.count());
            this.addMetric(metrics, id, "avg", wallTime, summary.mean());
            this.addMetric(metrics, id, "max", wallTime, summary.max());
        }
        return metrics.build();
    }

    Stream<WavefrontMetricLineData> writeMeter(Meter meter) {
        long wallTime = this.clock.wallTime();
        Stream.Builder metrics = Stream.builder();
        StreamSupport.stream(meter.measure().spliterator(), false).forEach(measurement -> {
            Meter.Id id = meter.getId().withTag(measurement.getStatistic());
            this.addMetric(metrics, id, null, wallTime, measurement.getValue());
        });
        return metrics.build();
    }

    void addMetric(Stream.Builder<WavefrontMetricLineData> metrics, Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        if (!Double.isFinite(value)) {
            return;
        }
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        String name = this.getConventionName(fullId);
        String source = this.config.source();
        Map<String, String> tags = this.getTagsAsMap(id);
        try {
            String lineData = Utils.metricToLineData((String)name, (double)value, (Long)wallTime, (String)source, tags, (String)"unknown");
            metrics.add(new WavefrontMetricLineData(lineData, false));
        }
        catch (IllegalArgumentException e) {
            this.logger.error("failed to convert metric to Wavefront format: " + fullId.getName(), (Throwable)e);
        }
    }

    void addDistribution(Stream.Builder<WavefrontMetricLineData> metrics, Meter.Id id, List<WavefrontHistogramImpl.Distribution> distributions) {
        String name = this.getConventionName(id);
        String source = this.config.source();
        Map<String, String> tags = this.getTagsAsMap(id);
        for (WavefrontHistogramImpl.Distribution distribution : distributions) {
            try {
                String lineData = Utils.histogramToLineData((String)name, (List)distribution.centroids, this.histogramGranularities, (Long)distribution.timestamp, (String)source, tags, (String)"unknown");
                metrics.add(new WavefrontMetricLineData(lineData, true));
            }
            catch (IllegalArgumentException e) {
                this.logger.error("failed to convert distribution to Wavefront format: " + id.getName(), (Throwable)e);
            }
        }
    }

    private Map<String, String> getTagsAsMap(Meter.Id id) {
        return this.getConventionTags(id).stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue, (tag1, tag2) -> tag2));
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return id.withName(id.getName() + "." + suffix);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    public static Builder builder(WavefrontConfig config) {
        return new Builder(config);
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final WavefrontConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = WavefrontMeterRegistry.access$000();
        private HttpSender httpClient;

        Builder(WavefrontConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public WavefrontMeterRegistry build() {
            return new WavefrontMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }
}

