/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.MissingBackpressureException;
import rx.functions.FuncN;
import rx.internal.util.RxRingBuffer;

public final class OnSubscribeCombineLatest<T, R>
implements Observable.OnSubscribe<R> {
    final List<? extends Observable<? extends T>> sources;
    final FuncN<? extends R> combinator;

    public OnSubscribeCombineLatest(List<? extends Observable<? extends T>> sources, FuncN<? extends R> combinator) {
        this.sources = sources;
        this.combinator = combinator;
        if (sources.size() > 128) {
            throw new IllegalArgumentException("More than 128 sources to combineLatest is not supported.");
        }
    }

    @Override
    public void call(Subscriber<? super R> child) {
        if (this.sources.isEmpty()) {
            child.onCompleted();
            return;
        }
        if (this.sources.size() == 1) {
            child.setProducer(new SingleSourceProducer<T, R>(child, this.sources.get(0), this.combinator));
        } else {
            child.setProducer(new MultiSourceProducer(child, this.sources, this.combinator));
        }
    }

    static final class SingleSourceRequestableSubscriber<T, R>
    extends Subscriber<T> {
        private final Subscriber<? super R> child;
        private final FuncN<? extends R> combinator;

        SingleSourceRequestableSubscriber(Subscriber<? super R> child, FuncN<? extends R> combinator) {
            super(child);
            this.child = child;
            this.combinator = combinator;
        }

        public void requestMore(long n) {
            this.request(n);
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(this.combinator.call(t));
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
        }
    }

    static final class SingleSourceProducer<T, R>
    implements Producer {
        final AtomicBoolean started = new AtomicBoolean();
        final Observable<? extends T> source;
        final Subscriber<? super R> child;
        final FuncN<? extends R> combinator;
        final SingleSourceRequestableSubscriber<T, R> subscriber;

        public SingleSourceProducer(Subscriber<? super R> child, Observable<? extends T> source, FuncN<? extends R> combinator) {
            this.source = source;
            this.child = child;
            this.combinator = combinator;
            this.subscriber = new SingleSourceRequestableSubscriber(child, combinator);
        }

        @Override
        public void request(long n) {
            this.subscriber.requestMore(n);
            if (this.started.compareAndSet(false, true)) {
                this.source.unsafeSubscribe(this.subscriber);
            }
        }
    }

    static final class MultiSourceRequestableSubscriber<T, R>
    extends Subscriber<T> {
        final MultiSourceProducer<T, R> producer;
        final int index;
        final AtomicLong emitted = new AtomicLong();
        boolean hasValue = false;

        public MultiSourceRequestableSubscriber(int index, int initial, Subscriber<? super R> child, MultiSourceProducer<T, R> producer) {
            super(child);
            this.index = index;
            this.producer = producer;
            this.request(initial);
        }

        public void requestUpTo(long n) {
            long u;
            long r;
            while (!this.emitted.compareAndSet(r = this.emitted.get(), r - (u = Math.min(r, n)))) {
            }
            this.request(u);
        }

        @Override
        public void onCompleted() {
            this.producer.onCompleted(this.index, this.hasValue);
        }

        @Override
        public void onError(Throwable e) {
            this.producer.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.hasValue = true;
            this.emitted.incrementAndGet();
            boolean emitted = this.producer.onNext(this.index, t);
            if (!emitted) {
                this.request(1L);
            }
        }
    }

    static final class MultiSourceProducer<T, R>
    implements Producer {
        private final AtomicBoolean started = new AtomicBoolean();
        private final AtomicLong requested = new AtomicLong();
        private final List<? extends Observable<? extends T>> sources;
        private final Subscriber<? super R> child;
        private final FuncN<? extends R> combinator;
        private final MultiSourceRequestableSubscriber<T, R>[] subscribers;
        private final RxRingBuffer buffer = RxRingBuffer.getSpmcInstance();
        private final Object[] collectedValues;
        private final BitSet haveValues;
        private volatile int haveValuesCount;
        private final BitSet completion;
        private volatile int completionCount;
        private volatile long counter;
        private static final AtomicLongFieldUpdater<MultiSourceProducer> WIP = AtomicLongFieldUpdater.newUpdater(MultiSourceProducer.class, "counter");

        public MultiSourceProducer(Subscriber<? super R> child, List<? extends Observable<? extends T>> sources, FuncN<? extends R> combinator) {
            this.sources = sources;
            this.child = child;
            this.combinator = combinator;
            int n = sources.size();
            this.subscribers = new MultiSourceRequestableSubscriber[n];
            this.collectedValues = new Object[n];
            this.haveValues = new BitSet(n);
            this.completion = new BitSet(n);
        }

        @Override
        public void request(long n) {
            this.requested.getAndAdd(n);
            if (!this.started.get() && this.started.compareAndSet(false, true)) {
                int sizePerSubscriber = RxRingBuffer.SIZE / this.sources.size();
                int leftOver = RxRingBuffer.SIZE % this.sources.size();
                for (int i = 0; i < this.sources.size(); ++i) {
                    Observable<T> o = this.sources.get(i);
                    int toRequest = sizePerSubscriber;
                    if (i == this.sources.size() - 1) {
                        toRequest += leftOver;
                    }
                    MultiSourceRequestableSubscriber s = new MultiSourceRequestableSubscriber(i, toRequest, this.child, this);
                    this.subscribers[i] = s;
                    o.unsafeSubscribe(s);
                }
            }
            this.tick();
        }

        void tick() {
            if (WIP.getAndIncrement(this) == 0L) {
                int emitted = 0;
                do {
                    Object o;
                    if (this.requested.get() <= 0L || (o = this.buffer.poll()) == null) continue;
                    if (this.buffer.isCompleted(o)) {
                        this.child.onCompleted();
                        continue;
                    }
                    this.buffer.accept(o, this.child);
                    ++emitted;
                    this.requested.decrementAndGet();
                } while (WIP.decrementAndGet(this) > 0L);
                if (emitted > 0) {
                    for (MultiSourceRequestableSubscriber<T, R> s : this.subscribers) {
                        s.requestUpTo(emitted);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleted(int index, boolean hadValue) {
            if (!hadValue) {
                this.child.onCompleted();
                return;
            }
            boolean done = false;
            MultiSourceProducer multiSourceProducer = this;
            synchronized (multiSourceProducer) {
                if (!this.completion.get(index)) {
                    this.completion.set(index);
                    ++this.completionCount;
                    done = this.completionCount == this.collectedValues.length;
                }
            }
            if (done) {
                this.buffer.onCompleted();
                this.tick();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onNext(int index, T t) {
            MultiSourceProducer multiSourceProducer = this;
            synchronized (multiSourceProducer) {
                if (!this.haveValues.get(index)) {
                    this.haveValues.set(index);
                    ++this.haveValuesCount;
                }
                this.collectedValues[index] = t;
                if (this.haveValuesCount != this.collectedValues.length) {
                    return false;
                }
                try {
                    this.buffer.onNext(this.combinator.call(this.collectedValues));
                }
                catch (MissingBackpressureException e) {
                    this.onError(e);
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }
            this.tick();
            return true;
        }

        public void onError(Throwable e) {
            this.child.onError(e);
        }
    }
}

