/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport.netty.tcp;

import io.netty.channel.ChannelOption;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.TransportConfig;
import io.scalecube.net.Address;
import io.scalecube.transport.netty.Sender;
import io.scalecube.transport.netty.TransportImpl;
import io.scalecube.transport.netty.tcp.TcpChannelInitializer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;

final class TcpSender
implements Sender {
    private final TransportConfig config;

    TcpSender(TransportConfig config) {
        this.config = config;
    }

    @Override
    public Mono<Connection> connect(Address address) {
        return Mono.deferContextual(context -> Mono.just((Object)context.get(TransportImpl.SenderContext.class))).map(context -> this.newTcpClient((TransportImpl.SenderContext)context, address)).flatMap(TcpClient::connect);
    }

    @Override
    public Mono<Void> send(Message message) {
        return Mono.deferContextual(context -> {
            Connection connection = (Connection)context.get(Connection.class);
            TransportImpl.SenderContext senderContext = (TransportImpl.SenderContext)context.get(TransportImpl.SenderContext.class);
            return connection.outbound().sendObject((Publisher)Mono.just((Object)message).map(senderContext.messageEncoder()), bb -> true).then();
        });
    }

    private TcpClient newTcpClient(TransportImpl.SenderContext context, Address address) {
        TcpClient tcpClient = (TcpClient)TcpClient.newConnection().runOn(context.loopResources()).host(address.host()).port(address.port()).option(ChannelOption.TCP_NODELAY, (Object)true).option(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.SO_REUSEADDR, (Object)true).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.connectTimeout()).doOnChannelInit((connectionObserver, channel, remoteAddress) -> new TcpChannelInitializer(this.config.maxFrameLength()).accept(connectionObserver, channel));
        return this.config.isClientSecured() ? tcpClient.secure() : tcpClient;
    }
}

