/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata.protocol.transaction;

import io.netty.buffer.ByteBuf;
import io.seata.codec.seata.protocol.transaction.AbstractTransactionRequestToTCCodec;
import io.seata.core.model.BranchType;
import io.seata.core.protocol.transaction.BranchRegisterRequest;
import java.nio.ByteBuffer;

public class BranchRegisterRequestCodec
extends AbstractTransactionRequestToTCCodec {
    @Override
    public Class<?> getMessageClassType() {
        return BranchRegisterRequest.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        byte[] bs;
        BranchRegisterRequest branchRegisterRequest = (BranchRegisterRequest)t;
        String xid = branchRegisterRequest.getXid();
        BranchType branchType = branchRegisterRequest.getBranchType();
        String resourceId = branchRegisterRequest.getResourceId();
        String lockKey = branchRegisterRequest.getLockKey();
        String applicationData = branchRegisterRequest.getApplicationData();
        byte[] lockKeyBytes = null;
        if (lockKey != null) {
            lockKeyBytes = lockKey.getBytes(UTF8);
        }
        byte[] applicationDataBytes = null;
        if (applicationData != null) {
            applicationDataBytes = applicationData.getBytes(UTF8);
        }
        if (xid != null) {
            bs = xid.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        out.writeByte(branchType.ordinal());
        if (resourceId != null) {
            bs = resourceId.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        if (lockKey != null) {
            out.writeInt(lockKeyBytes.length);
            if (lockKeyBytes.length > 0) {
                out.writeBytes(lockKeyBytes);
            }
        } else {
            out.writeInt(0);
        }
        if (applicationData != null) {
            out.writeInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                out.writeBytes(applicationDataBytes);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        int applicationDataLen;
        int iLen;
        BranchRegisterRequest branchRegisterRequest = (BranchRegisterRequest)t;
        short xidLen = in.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            in.get(bs);
            branchRegisterRequest.setXid(new String(bs, UTF8));
        }
        branchRegisterRequest.setBranchType(BranchType.get((byte)in.get()));
        short len = in.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            in.get(bs);
            branchRegisterRequest.setResourceId(new String(bs, UTF8));
        }
        if ((iLen = in.getInt()) > 0) {
            byte[] bs = new byte[iLen];
            in.get(bs);
            branchRegisterRequest.setLockKey(new String(bs, UTF8));
        }
        if ((applicationDataLen = in.getInt()) > 0) {
            byte[] bs = new byte[applicationDataLen];
            in.get(bs);
            branchRegisterRequest.setApplicationData(new String(bs, UTF8));
        }
    }
}

