/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ConfigurationProperties(prefix="spring.cloud.alibaba.seata")
public class SpringCloudAlibabaConfiguration
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudAlibabaConfiguration.class);
    private static final String SPRING_APPLICATION_NAME_KEY = "spring.application.name";
    private static final String DEFAULT_SPRING_CLOUD_SERVICE_GROUP_POSTFIX = "-seata-service-group";
    private String applicationId;
    private String txServiceGroup;
    private ApplicationContext applicationContext;

    public String getApplicationId() {
        if (null == this.applicationId) {
            this.applicationId = this.applicationContext.getEnvironment().getProperty(SPRING_APPLICATION_NAME_KEY);
        }
        return this.applicationId;
    }

    public String getTxServiceGroup() {
        if (null == this.txServiceGroup) {
            String applicationId = this.getApplicationId();
            if (null == applicationId) {
                LOGGER.warn("{} is null, please set its value", (Object)SPRING_APPLICATION_NAME_KEY);
            }
            this.txServiceGroup = applicationId + DEFAULT_SPRING_CLOUD_SERVICE_GROUP_POSTFIX;
        }
        return this.txServiceGroup;
    }

    public void setTxServiceGroup(String txServiceGroup) {
        this.txServiceGroup = txServiceGroup;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

