/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.RootContext;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.TransactionManager;
import io.seata.tm.TransactionManagerHolder;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalTransaction
implements GlobalTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGlobalTransaction.class);
    private static final int DEFAULT_GLOBAL_TX_TIMEOUT = 60000;
    private static final String DEFAULT_GLOBAL_TX_NAME = "default";
    private TransactionManager transactionManager = TransactionManagerHolder.get();
    private String xid;
    private GlobalStatus status;
    private GlobalTransactionRole role;
    private static final int COMMIT_RETRY_COUNT = ConfigurationFactory.getInstance().getInt("client.tm.commit.retry.count", 1);
    private static final int ROLLBACK_RETRY_COUNT = ConfigurationFactory.getInstance().getInt("client.tm.rollback.retry.count", 1);

    DefaultGlobalTransaction() {
        this(null, GlobalStatus.UnKnown, GlobalTransactionRole.Launcher);
    }

    DefaultGlobalTransaction(String xid, GlobalStatus status, GlobalTransactionRole role) {
        this.xid = xid;
        this.status = status;
        this.role = role;
    }

    @Override
    public void begin() throws TransactionException {
        this.begin(60000);
    }

    @Override
    public void begin(int timeout) throws TransactionException {
        this.begin(timeout, DEFAULT_GLOBAL_TX_NAME);
    }

    @Override
    public void begin(int timeout, String name) throws TransactionException {
        if (this.role != GlobalTransactionRole.Launcher) {
            this.check();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Begin(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        if (this.xid != null) {
            throw new IllegalStateException();
        }
        if (RootContext.getXID() != null) {
            throw new IllegalStateException();
        }
        this.xid = this.transactionManager.begin(null, null, name, timeout);
        this.status = GlobalStatus.Begin;
        RootContext.bind((String)this.xid);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Begin new global transaction [{}]", (Object)this.xid);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Commit(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        if (this.xid == null) {
            throw new IllegalStateException();
        }
        int retry = COMMIT_RETRY_COUNT;
        try {
            while (retry > 0) {
                try {
                    this.status = this.transactionManager.commit(this.xid);
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to report global commit [{}],Retry Countdown: {}, reason: {}", new Object[]{this.getXid(), retry, ex.getMessage()});
                    if (--retry != 0) continue;
                    throw new TransactionException("Failed to report global commit", ex);
                }
            }
        }
        finally {
            if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
                RootContext.unbind();
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] commit status: {}", (Object)this.xid, (Object)this.status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Rollback(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        if (this.xid == null) {
            throw new IllegalStateException();
        }
        int retry = ROLLBACK_RETRY_COUNT;
        try {
            while (retry > 0) {
                try {
                    this.status = this.transactionManager.rollback(this.xid);
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to report global rollback [{}],Retry Countdown: {}, reason: {}", new Object[]{this.getXid(), retry, ex.getMessage()});
                    if (--retry != 0) continue;
                    throw new TransactionException("Failed to report global rollback", ex);
                }
            }
        }
        finally {
            if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
                RootContext.unbind();
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] rollback status: {}", (Object)this.xid, (Object)this.status);
        }
    }

    @Override
    public GlobalStatus getStatus() throws TransactionException {
        if (this.xid == null) {
            return GlobalStatus.UnKnown;
        }
        this.status = this.transactionManager.getStatus(this.xid);
        return this.status;
    }

    @Override
    public String getXid() {
        return this.xid;
    }

    @Override
    public void globalReport(GlobalStatus globalStatus) throws TransactionException {
        if (this.xid == null) {
            throw new IllegalStateException();
        }
        if (globalStatus == null) {
            throw new IllegalStateException();
        }
        this.status = this.transactionManager.globalReport(this.xid, globalStatus);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] report status: {}", (Object)this.xid, (Object)this.status);
        }
        if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
            RootContext.unbind();
        }
    }

    private void check() {
        if (this.xid == null) {
            throw new ShouldNeverHappenException();
        }
    }
}

