/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.ssl;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CertificateUtil {
    private static final int SUBALTNAME_DNSNAME = 2;
    private static final int SUBALTNAME_IPADDRESS = 7;

    private CertificateUtil() {
    }

    private static X509Certificate[] sort(X509Certificate[] cerChain) {
        X509Certificate root;
        X509Certificate[] chain = new X509Certificate[cerChain.length];
        chain[0] = root = CertificateUtil.findRootCA(cerChain);
        block0: for (int i = 1; i < chain.length; ++i) {
            X509Certificate parent = chain[i - 1];
            for (int j = 0; j < cerChain.length; ++j) {
                String childIssuerDN;
                String childDN;
                X509Certificate child = cerChain[j];
                String parentDN = parent.getSubjectX500Principal().getName();
                if (parentDN.equals(childDN = child.getSubjectX500Principal().getName()) || !parentDN.equals(childIssuerDN = child.getIssuerX500Principal().getName())) continue;
                chain[i] = child;
                continue block0;
            }
        }
        return chain;
    }

    private static X509Certificate findRootCA(X509Certificate[] cerChain) {
        if (cerChain.length == 1) {
            return cerChain[0];
        }
        for (X509Certificate item : cerChain) {
            String issuserDN;
            String subjectDN = item.getSubjectX500Principal().getName();
            if (!subjectDN.equals(issuserDN = item.getIssuerX500Principal().getName())) continue;
            return item;
        }
        throw new IllegalArgumentException("bad certificate chain: no root CA.");
    }

    public static X509Certificate findOwner(X509Certificate[] cerChain) {
        X509Certificate[] sorted = CertificateUtil.sort(cerChain);
        return sorted[sorted.length - 1];
    }

    public static Set<String> getCN(X509Certificate cert) {
        String[] pairs;
        HashSet<String> names = new HashSet<String>();
        String subjectDN = cert.getSubjectX500Principal().getName();
        for (String p : pairs = subjectDN.split(",")) {
            String[] kv = p.split("=");
            if (kv.length != 2 || !kv[0].equals("CN")) continue;
            names.add(kv[1]);
        }
        try {
            Collection<List<?>> collection = cert.getSubjectAlternativeNames();
            if (collection != null) {
                for (List<?> list : collection) {
                    if (list.size() != 2) continue;
                    Object key = list.get(0);
                    Object value = list.get(1);
                    if (!(key instanceof Integer) || !(value instanceof String)) continue;
                    int intKey = (Integer)key;
                    String strValue = (String)value;
                    if (intKey != 2 && intKey != 7) continue;
                    names.add(strValue);
                }
            }
        }
        catch (CertificateParsingException e) {
            throw new IllegalArgumentException("can not read AlternativeNames.");
        }
        return names;
    }
}

