/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dal.show;

import io.shardingsphere.core.merger.MergedResult;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public final class ShowDatabasesMergedResult
implements MergedResult {
    private final List<String> schemas;
    private int currentIndex;

    public ShowDatabasesMergedResult() {
        this(Collections.singletonList("sharding_db"));
    }

    @Override
    public boolean next() {
        if (this.currentIndex < this.schemas.size()) {
            ++this.currentIndex;
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.schemas.get(this.currentIndex - 1);
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) throws SQLException {
        return this.getValue(1, type);
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean wasNull() {
        return false;
    }

    @ConstructorProperties(value={"schemas"})
    public ShowDatabasesMergedResult(List<String> schemas) {
        this.schemas = schemas;
    }
}

