/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.AggregationType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.AliasExpressionParser;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.CommonSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.StarSelectItem;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;
import java.util.List;

public abstract class SelectListClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AliasExpressionParser aliasExpressionParser;

    public SelectListClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.aliasExpressionParser = ExpressionParserFactory.createAliasExpressionParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement, List<SelectItem> items) {
        do {
            selectStatement.getItems().add(this.parseSelectItem(selectStatement));
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        selectStatement.setSelectListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
        items.addAll(selectStatement.getItems());
    }

    private SelectItem parseSelectItem(SelectStatement selectStatement) {
        SelectItem result;
        this.lexerEngine.skipIfEqual(this.getSkippedKeywordsBeforeSelectItem());
        if (this.isRowNumberSelectItem()) {
            result = this.parseRowNumberSelectItem(selectStatement);
        } else if (this.isStarSelectItem()) {
            selectStatement.setContainStar(true);
            result = this.parseStarSelectItem();
        } else if (this.isAggregationSelectItem()) {
            result = this.parseAggregationSelectItem(selectStatement);
            this.parseRestSelectItem(selectStatement);
        } else {
            result = this.parseCommonOrStarSelectItem(selectStatement);
        }
        return result;
    }

    protected abstract Keyword[] getSkippedKeywordsBeforeSelectItem();

    protected abstract boolean isRowNumberSelectItem();

    protected abstract SelectItem parseRowNumberSelectItem(SelectStatement var1);

    private boolean isStarSelectItem() {
        return Symbol.STAR.getLiterals().equals(SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals()));
    }

    private SelectItem parseStarSelectItem() {
        this.lexerEngine.nextToken();
        this.aliasExpressionParser.parseSelectItemAlias();
        return new StarSelectItem((Optional<String>)Optional.absent());
    }

    private SelectItem parseStarSelectItem(String owner) {
        this.lexerEngine.nextToken();
        this.aliasExpressionParser.parseSelectItemAlias();
        return new StarSelectItem((Optional<String>)Optional.fromNullable((Object)owner));
    }

    private SelectItem parseCommonOrStarSelectItem(SelectStatement selectStatement) {
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int position = this.lexerEngine.getCurrentToken().getEndPosition() - literals.length();
        StringBuilder result = new StringBuilder();
        result.append(literals);
        this.lexerEngine.nextToken();
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            result.append(this.lexerEngine.skipParentheses(selectStatement));
        } else if (this.lexerEngine.equalAny(Symbol.DOT)) {
            String tableName = SQLUtil.getExactlyValue(literals);
            if (this.shardingRule.tryFindTableRuleByLogicTable(tableName).isPresent() || this.shardingRule.findBindingTableRule(tableName).isPresent()) {
                selectStatement.addSQLToken(new TableToken(position, 0, literals));
            }
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
            if (this.lexerEngine.equalAny(Symbol.STAR)) {
                return this.parseStarSelectItem(literals);
            }
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
        }
        return new CommonSelectItem(SQLUtil.getExactlyValue(result + this.parseRestSelectItem(selectStatement)), this.aliasExpressionParser.parseSelectItemAlias());
    }

    private boolean isAggregationSelectItem() {
        return this.lexerEngine.equalAny(DefaultKeyword.MAX, DefaultKeyword.MIN, DefaultKeyword.SUM, DefaultKeyword.AVG, DefaultKeyword.COUNT);
    }

    private SelectItem parseAggregationSelectItem(SelectStatement selectStatement) {
        AggregationType aggregationType = AggregationType.valueOf(this.lexerEngine.getCurrentToken().getLiterals().toUpperCase());
        this.lexerEngine.nextToken();
        return new AggregationSelectItem(aggregationType, this.lexerEngine.skipParentheses(selectStatement), this.aliasExpressionParser.parseSelectItemAlias());
    }

    private String parseRestSelectItem(SelectStatement selectStatement) {
        StringBuilder result = new StringBuilder();
        while (this.lexerEngine.equalAny(Symbol.getOperators())) {
            result.append(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
            SelectItem selectItem = this.parseCommonOrStarSelectItem(selectStatement);
            result.append(selectItem.getExpression());
        }
        return result.toString();
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    public AliasExpressionParser getAliasExpressionParser() {
        return this.aliasExpressionParser;
    }
}

