/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.postgresql.sql;

import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.clause.PostgreSQLForClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.clause.PostgreSQLLimitClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.clause.facade.PostgreSQLSelectClauseParserFacade;
import io.shardingsphere.core.parsing.parser.sql.dql.select.AbstractSelectParser;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class PostgreSQLSelectParser
extends AbstractSelectParser {
    private final PostgreSQLLimitClauseParser limitClauseParser;
    private final PostgreSQLForClauseParser forClauseParser;

    public PostgreSQLSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        super(shardingRule, lexerEngine, new PostgreSQLSelectClauseParserFacade(shardingRule, lexerEngine), shardingTableMetaData);
        this.limitClauseParser = new PostgreSQLLimitClauseParser(lexerEngine);
        this.forClauseParser = new PostgreSQLForClauseParser(lexerEngine);
    }

    @Override
    protected void parseInternal(SelectStatement selectStatement) {
        this.parseDistinct();
        this.parseSelectList(selectStatement, this.getItems());
        this.parseFrom(selectStatement);
        this.parseWhere(this.getShardingRule(), selectStatement, this.getItems());
        this.parseGroupBy(selectStatement);
        this.parseHaving();
        this.parseOrderBy(selectStatement);
        this.parseLimit(selectStatement);
        this.parseFor();
        this.parseSelectRest();
    }

    private void parseLimit(SelectStatement selectStatement) {
        this.limitClauseParser.parse(selectStatement);
    }

    private void parseFor() {
        this.forClauseParser.parse();
    }
}

