/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.model.ConfigInfoBase;
import com.alibaba.nacos.config.server.model.event.LocalDataChangeEvent;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ClientIpWhiteList;
import com.alibaba.nacos.config.server.service.SwitchService;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.utils.DiskUtil;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigCacheService {
    static final Logger LOGGER = LoggerFactory.getLogger(ConfigCacheService.class);
    private static final String NO_SPACE_CN = "\u8bbe\u5907\u4e0a\u6ca1\u6709\u7a7a\u95f4";
    private static final String NO_SPACE_EN = "No space left on device";
    private static final String DISK_QUATA_CN = "\u8d85\u51fa\u78c1\u76d8\u9650\u989d";
    private static final String DISK_QUATA_EN = "Disk quota exceeded";
    private static final ConcurrentHashMap<String, CacheItem> CACHE = new ConcurrentHashMap();
    @Autowired
    private static PersistService persistService;

    public static int groupCount() {
        return CACHE.size();
    }

    public static boolean hasGroupKey(String groupKey) {
        return CACHE.containsKey(groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dump(String dataId, String group, String tenant, String content, long lastModifiedTs, String type) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        CacheItem ci = ConfigCacheService.makeSure(groupKey);
        ci.setType(type);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        assert (lockResult != 0);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            if (md5.equals(ConfigCacheService.getContentMd5(groupKey))) {
                LogUtil.DUMP_LOG.warn("[dump-ignore] ignore to save cache file. groupKey={}, md5={}, lastModifiedOld={}, lastModifiedNew={}", new Object[]{groupKey, md5, ConfigCacheService.getLastModifiedTs(groupKey), lastModifiedTs});
            } else if (!PropertyUtil.isDirectRead()) {
                DiskUtil.saveToDisk(dataId, group, tenant, content);
            }
            ConfigCacheService.updateMd5(groupKey, md5, lastModifiedTs);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            String errMsg;
            LogUtil.DUMP_LOG.error("[dump-exception] save disk error. " + groupKey + ", " + ioe.toString(), (Throwable)ioe);
            if (ioe.getMessage() != null && (NO_SPACE_CN.equals(errMsg = ioe.getMessage()) || NO_SPACE_EN.equals(errMsg) || errMsg.contains(DISK_QUATA_CN) || errMsg.contains(DISK_QUATA_EN))) {
                LogUtil.FATAL_LOG.error("\u78c1\u76d8\u6ee1\u81ea\u6740\u9000\u51fa", (Throwable)ioe);
                System.exit(0);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpBeta(String dataId, String group, String tenant, String content, long lastModifiedTs, String betaIps) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        ConfigCacheService.makeSure(groupKey);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        assert (lockResult != 0);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-beta-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            if (md5.equals(ConfigCacheService.getContentBetaMd5(groupKey))) {
                LogUtil.DUMP_LOG.warn("[dump-beta-ignore] ignore to save cache file. groupKey={}, md5={}, lastModifiedOld={}, lastModifiedNew={}", new Object[]{groupKey, md5, ConfigCacheService.getLastModifiedTs(groupKey), lastModifiedTs});
            } else if (!PropertyUtil.isDirectRead()) {
                DiskUtil.saveBetaToDisk(dataId, group, tenant, content);
            }
            String[] betaIpsArr = betaIps.split(",");
            ConfigCacheService.updateBetaMd5(groupKey, md5, Arrays.asList(betaIpsArr), lastModifiedTs);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            LogUtil.DUMP_LOG.error("[dump-beta-exception] save disk error. " + groupKey + ", " + ioe.toString(), (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpTag(String dataId, String group, String tenant, String tag, String content, long lastModifiedTs) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        ConfigCacheService.makeSure(groupKey);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        assert (lockResult != 0);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-tag-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            if (md5.equals(ConfigCacheService.getContentTagMd5(groupKey, tag))) {
                LogUtil.DUMP_LOG.warn("[dump-tag-ignore] ignore to save cache file. groupKey={}, md5={}, lastModifiedOld={}, lastModifiedNew={}", new Object[]{groupKey, md5, ConfigCacheService.getLastModifiedTs(groupKey), lastModifiedTs});
            } else if (!PropertyUtil.isDirectRead()) {
                DiskUtil.saveTagToDisk(dataId, group, tenant, tag, content);
            }
            ConfigCacheService.updateTagMd5(groupKey, tag, md5, lastModifiedTs);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            LogUtil.DUMP_LOG.error("[dump-tag-exception] save disk error. " + groupKey + ", " + ioe.toString(), (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpChange(String dataId, String group, String tenant, String content, long lastModifiedTs) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        ConfigCacheService.makeSure(groupKey);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        assert (lockResult != 0);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            if (!PropertyUtil.isDirectRead()) {
                String localMd5 = DiskUtil.getLocalConfigMd5(dataId, group, tenant);
                if (md5.equals(localMd5)) {
                    LogUtil.DUMP_LOG.warn("[dump-ignore] ignore to save cache file. groupKey={}, md5={}, lastModifiedOld={}, lastModifiedNew={}", new Object[]{groupKey, md5, ConfigCacheService.getLastModifiedTs(groupKey), lastModifiedTs});
                } else {
                    DiskUtil.saveToDisk(dataId, group, tenant, content);
                }
            }
            ConfigCacheService.updateMd5(groupKey, md5, lastModifiedTs);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            LogUtil.DUMP_LOG.error("[dump-exception] save disk error. " + groupKey + ", " + ioe.toString(), (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    public static void reloadConfig() {
        String aggreds = null;
        try {
            if (PropertyUtil.isEmbeddedStorage()) {
                ConfigInfoBase config = persistService.findConfigInfoBase("com.alibaba.nacos.metadata.aggrIDs", "DEFAULT_GROUP");
                if (config != null) {
                    aggreds = config.getContent();
                }
            } else {
                aggreds = DiskUtil.getConfig("com.alibaba.nacos.metadata.aggrIDs", "DEFAULT_GROUP", "");
            }
            if (aggreds != null) {
                AggrWhitelist.load(aggreds);
            }
        }
        catch (IOException e) {
            LogUtil.DUMP_LOG.error("reload fail:com.alibaba.nacos.metadata.aggrIDs", (Throwable)e);
        }
        String clientIpWhitelist = null;
        try {
            if (PropertyUtil.isEmbeddedStorage()) {
                ConfigInfoBase config = persistService.findConfigInfoBase("com.alibaba.nacos.metadata.clientIpWhitelist", "DEFAULT_GROUP");
                if (config != null) {
                    clientIpWhitelist = config.getContent();
                }
            } else {
                clientIpWhitelist = DiskUtil.getConfig("com.alibaba.nacos.metadata.clientIpWhitelist", "DEFAULT_GROUP", "");
            }
            if (clientIpWhitelist != null) {
                ClientIpWhiteList.load(clientIpWhitelist);
            }
        }
        catch (IOException e) {
            LogUtil.DUMP_LOG.error("reload fail:com.alibaba.nacos.metadata.clientIpWhitelist", (Throwable)e);
        }
        String switchContent = null;
        try {
            if (PropertyUtil.isEmbeddedStorage()) {
                ConfigInfoBase config = persistService.findConfigInfoBase("com.alibaba.nacos.meta.switch", "DEFAULT_GROUP");
                if (config != null) {
                    switchContent = config.getContent();
                }
            } else {
                switchContent = DiskUtil.getConfig("com.alibaba.nacos.meta.switch", "DEFAULT_GROUP", "");
            }
            if (switchContent != null) {
                SwitchService.load(switchContent);
            }
        }
        catch (IOException e) {
            LogUtil.DUMP_LOG.error("reload fail:com.alibaba.nacos.meta.switch", (Throwable)e);
        }
    }

    public static List<String> checkMd5() {
        ArrayList<String> diffList = new ArrayList<String>();
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, CacheItem> entry : CACHE.entrySet()) {
            String groupKey = entry.getKey();
            String[] dg = GroupKey.parseKey(groupKey);
            String dataId = dg[0];
            String group = dg[1];
            String tenant = dg[2];
            try {
                String loacalMd5 = DiskUtil.getLocalConfigMd5(dataId, group, tenant);
                if (entry.getValue().md5.equals(loacalMd5)) continue;
                LogUtil.DEFAULT_LOG.warn("[md5-different] dataId:{},group:{}", (Object)dataId, (Object)group);
                diffList.add(groupKey);
            }
            catch (IOException e) {
                LogUtil.DEFAULT_LOG.error("getLocalConfigMd5 fail,dataId:{},group:{}", (Object)dataId, (Object)group);
            }
        }
        long endTime = System.currentTimeMillis();
        LogUtil.DEFAULT_LOG.warn("checkMd5 cost:{}; diffCount:{}", (Object)(endTime - startTime), (Object)diffList.size());
        return diffList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(String dataId, String group, String tenant) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            if (!PropertyUtil.isDirectRead()) {
                DiskUtil.removeConfigInfo(dataId, group, tenant);
            }
            CACHE.remove(groupKey);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeBeta(String dataId, String group, String tenant) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            if (!PropertyUtil.isDirectRead()) {
                DiskUtil.removeConfigInfo4Beta(dataId, group, tenant);
            }
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, true, CACHE.get(groupKey).getIps4Beta()));
            CACHE.get(groupKey).setBeta(false);
            CACHE.get(groupKey).setIps4Beta(null);
            CACHE.get(groupKey).setMd54Beta("");
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeTag(String dataId, String group, String tenant, String tag) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            if (!PropertyUtil.isDirectRead()) {
                DiskUtil.removeConfigInfo4Tag(dataId, group, tenant, tag);
            }
            CacheItem ci = CACHE.get(groupKey);
            ci.tagMd5.remove(tag);
            ci.tagLastModifiedTs.remove(tag);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, false, null, tag));
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    public static void updateMd5(String groupKey, String md5, long lastModifiedTs) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey);
        if (cache.md5 == null || !cache.md5.equals(md5)) {
            cache.md5 = md5;
            cache.lastModifiedTs = lastModifiedTs;
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
        }
    }

    public static void updateBetaMd5(String groupKey, String md5, List<String> ips4Beta, long lastModifiedTs) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey);
        if (cache.md54Beta == null || !cache.md54Beta.equals(md5)) {
            cache.isBeta = true;
            cache.md54Beta = md5;
            cache.lastModifiedTs4Beta = lastModifiedTs;
            cache.ips4Beta = ips4Beta;
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, true, ips4Beta));
        }
    }

    public static void updateTagMd5(String groupKey, String tag, String md5, long lastModifiedTs) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey);
        if (cache.tagMd5 == null) {
            HashMap<String, String> tagMd5Tmp = new HashMap<String, String>(1);
            tagMd5Tmp.put(tag, md5);
            cache.tagMd5 = tagMd5Tmp;
            if (cache.tagLastModifiedTs == null) {
                HashMap<String, Long> tagLastModifiedTsTmp = new HashMap<String, Long>(1);
                tagLastModifiedTsTmp.put(tag, lastModifiedTs);
                cache.tagLastModifiedTs = tagLastModifiedTsTmp;
            } else {
                cache.tagLastModifiedTs.put(tag, lastModifiedTs);
            }
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, false, null, tag));
            return;
        }
        if (cache.tagMd5.get(tag) == null || !cache.tagMd5.get(tag).equals(md5)) {
            cache.tagMd5.put(tag, md5);
            cache.tagLastModifiedTs.put(tag, lastModifiedTs);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, false, null, tag));
        }
    }

    public static String getContentMd5(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item ? item.md5 : "";
    }

    public static String getContentMd5(String groupKey, String ip, String tag) {
        CacheItem item = CACHE.get(groupKey);
        if (item != null && item.isBeta && item.ips4Beta.contains(ip)) {
            return item.md54Beta;
        }
        if (item != null && item.tagMd5 != null && item.tagMd5.size() > 0 && StringUtils.isNotBlank((String)tag) && item.tagMd5.containsKey(tag)) {
            return item.tagMd5.get(tag);
        }
        return null != item ? item.md5 : "";
    }

    public static String getContentBetaMd5(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item ? item.md54Beta : "";
    }

    public static String getContentTagMd5(String groupKey, String tag) {
        CacheItem item = CACHE.get(groupKey);
        if (item == null) {
            return "";
        }
        if (item.tagMd5 == null) {
            return "";
        }
        return item.tagMd5.get(tag);
    }

    public static List<String> getBetaIps(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item ? item.getIps4Beta() : Collections.emptyList();
    }

    public static CacheItem getContentCache(String groupKey) {
        return CACHE.get(groupKey);
    }

    public static long getLastModifiedTs(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item ? item.lastModifiedTs : 0L;
    }

    public static boolean isUptodate(String groupKey, String md5) {
        String serverMd5 = ConfigCacheService.getContentMd5(groupKey);
        return StringUtils.equals((String)md5, (String)serverMd5);
    }

    public static boolean isUptodate(String groupKey, String md5, String ip, String tag) {
        String serverMd5 = ConfigCacheService.getContentMd5(groupKey, ip, tag);
        return StringUtils.equals((String)md5, (String)serverMd5);
    }

    public static int tryReadLock(String groupKey) {
        int result;
        CacheItem groupItem = CACHE.get(groupKey);
        int n = null == groupItem ? 0 : (result = groupItem.rwLock.tryReadLock() ? 1 : -1);
        if (result < 0) {
            LogUtil.DEFAULT_LOG.warn("[read-lock] failed, {}, {}", (Object)result, (Object)groupKey);
        }
        return result;
    }

    public static void releaseReadLock(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        if (null != item) {
            item.rwLock.releaseReadLock();
        }
    }

    static int tryWriteLock(String groupKey) {
        int result;
        CacheItem groupItem = CACHE.get(groupKey);
        int n = null == groupItem ? 0 : (result = groupItem.rwLock.tryWriteLock() ? 1 : -1);
        if (result < 0) {
            LogUtil.DEFAULT_LOG.warn("[write-lock] failed, {}, {}", (Object)result, (Object)groupKey);
        }
        return result;
    }

    static void releaseWriteLock(String groupKey) {
        CacheItem groupItem = CACHE.get(groupKey);
        if (null != groupItem) {
            groupItem.rwLock.releaseWriteLock();
        }
    }

    static CacheItem makeSure(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        if (null != item) {
            return item;
        }
        CacheItem tmp = new CacheItem(groupKey);
        item = CACHE.putIfAbsent(groupKey, tmp);
        return null == item ? tmp : item;
    }
}

