/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.error;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import net.dreamlu.mica.core.utils.BeanUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.web.context.request.WebRequest;

public class MicaErrorAttributes
extends DefaultErrorAttributes {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicaErrorAttributes.class);

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions options) {
        R result;
        String requestUrl = (String)this.getAttr(webRequest, "jakarta.servlet.error.request_uri");
        if (StringUtil.isBlank((CharSequence)requestUrl)) {
            requestUrl = (String)this.getAttr(webRequest, "jakarta.servlet.forward.request_uri");
        }
        Integer status = (Integer)this.getAttr(webRequest, "jakarta.servlet.error.status_code");
        Throwable error = this.getError(webRequest);
        log.error("URL:{} error status:{}", new Object[]{requestUrl, status, error});
        if (error instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)error;
            result = serviceException.getResult();
            result = Optional.ofNullable(result).orElse(R.fail((IResultCode)SystemCode.FAILURE));
        } else {
            result = R.fail((IResultCode)SystemCode.FAILURE, (String)("System error status:" + status));
        }
        return BeanUtil.toMap((Object)result);
    }

    private <T> @Nullable T getAttr(WebRequest webRequest, String name) {
        return (T)webRequest.getAttribute(name, 0);
    }
}

