/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.utils;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import net.dreamlu.mica.core.utils.SystemUtil;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.logback.RollingPolicySystemProperty;

public class LoggingUtil {
    public static final String DEFAULT_LOG_DIR = "logs";
    public static final String LOG_FILE_ALL = "all.log";
    public static final String LOG_FILE_ERROR = "error.log";
    public static final String CONSOLE_APPENDER_NAME = "CONSOLE";
    public static final String FILE_APPENDER_NAME = "FILE";
    public static final String FILE_ERROR_APPENDER_NAME = "FILE_ERROR";
    public static final String DEFAULT_FILE_LOG_PATTERN = "${FILE_LOG_PATTERN:%d{${LOG_DATEFORMAT_PATTERN:yyyy-MM-dd HH:mm:ss.SSS}} ${LOG_LEVEL_PATTERN:%5p} ${PID:} --- [%t] %-40.40logger{39} : %m%n${LOG_EXCEPTION_CONVERSION_WORD:%wEx}}";

    public static void detachAppender(String name) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.getLogger("ROOT").detachAppender(name);
    }

    public static RollingPolicy rollingPolicy(LoggerContext context, FileAppender<?> appender, String logErrorFile) {
        SizeAndTimeBasedRollingPolicy rollingPolicy = new SizeAndTimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setCleanHistoryOnStart(SystemUtil.getPropToBool((String)RollingPolicySystemProperty.CLEAN_HISTORY_ON_START.getEnvironmentVariableName(), (boolean)false));
        rollingPolicy.setFileNamePattern(logErrorFile + ".%d{yyyy-MM-dd}.%i.gz");
        rollingPolicy.setMaxFileSize(FileSize.valueOf((String)SystemUtil.getProp((String)RollingPolicySystemProperty.MAX_FILE_SIZE.getEnvironmentVariableName(), (String)"10MB")));
        rollingPolicy.setMaxHistory(SystemUtil.getPropToInt((String)RollingPolicySystemProperty.MAX_HISTORY.getEnvironmentVariableName(), (int)7));
        rollingPolicy.setTotalSizeCap(FileSize.valueOf((String)SystemUtil.getProp((String)RollingPolicySystemProperty.TOTAL_SIZE_CAP.getEnvironmentVariableName(), (String)"0")));
        rollingPolicy.setParent(appender);
        rollingPolicy.start();
        return rollingPolicy;
    }
}

