/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ByteBufferUtil {
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static byte readByte(ByteBuffer buffer) {
        return buffer.get();
    }

    public static short readUnsignedByte(ByteBuffer buffer) {
        return (short)(ByteBufferUtil.readByte(buffer) & 0xFF);
    }

    public static ByteBuffer skipBytes(ByteBuffer buffer, int skip) {
        buffer.position(buffer.position() + skip);
        return buffer;
    }

    public static String toString(ByteBuffer buffer) {
        return new String(buffer.array(), StandardCharsets.UTF_8);
    }

    public static String toString(ByteBuffer buffer, Charset charset) {
        return new String(buffer.array(), buffer.position(), buffer.limit(), charset);
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }
}

