/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

import net.dreamlu.iot.mqtt.codec.DecoderException;
import net.dreamlu.iot.mqtt.codec.MqttFixedHeader;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.codec.MqttVersion;
import org.tio.core.ChannelContext;

public final class MqttCodecUtil {
    public static final char TOPIC_WILDCARDS_ONE = '+';
    public static final char TOPIC_WILDCARDS_MORE = '#';
    private static final String MQTT_VERSION_KEY = "MQTT_V";

    public static MqttVersion getMqttVersion(ChannelContext ctx) {
        MqttVersion version = (MqttVersion)((Object)ctx.get(MQTT_VERSION_KEY));
        if (version == null) {
            return MqttVersion.MQTT_3_1_1;
        }
        return version;
    }

    protected static void setMqttVersion(ChannelContext ctx, MqttVersion version) {
        ctx.set(MQTT_VERSION_KEY, (Object)version);
    }

    public static boolean isTopicFilter(String topicFilter) {
        return topicFilter.indexOf(43) >= 0 || topicFilter.indexOf(35) >= 0;
    }

    public static boolean isValidPublishTopicName(String topicName) {
        return !MqttCodecUtil.isTopicFilter(topicName);
    }

    protected static boolean isValidMessageId(int messageId) {
        return messageId != 0;
    }

    protected static boolean isValidClientId(MqttVersion mqttVersion, int maxClientIdLength, String clientId) {
        if (clientId == null) {
            return false;
        }
        switch (mqttVersion) {
            case MQTT_3_1: {
                return clientId.length() >= 1 && clientId.length() <= maxClientIdLength;
            }
            case MQTT_3_1_1: 
            case MQTT_5: {
                return true;
            }
        }
        throw new IllegalArgumentException((Object)((Object)mqttVersion) + " is unknown mqtt version");
    }

    protected static MqttFixedHeader validateFixedHeader(ChannelContext ctx, MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case PUBREL: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                if (mqttFixedHeader.qosLevel() != MqttQoS.AT_LEAST_ONCE) {
                    throw new DecoderException(mqttFixedHeader.messageType().name() + " message must have QoS 1");
                }
                return mqttFixedHeader;
            }
            case AUTH: {
                if (MqttCodecUtil.getMqttVersion(ctx) != MqttVersion.MQTT_5) {
                    throw new DecoderException("AUTH message requires at least MQTT 5");
                }
                return mqttFixedHeader;
            }
        }
        return mqttFixedHeader;
    }

    protected static MqttFixedHeader resetUnusedFields(MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: 
            case CONNACK: 
            case PUBACK: 
            case PUBREC: 
            case PUBCOMP: 
            case SUBACK: 
            case UNSUBACK: 
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                if (mqttFixedHeader.isDup() || mqttFixedHeader.qosLevel() != MqttQoS.AT_MOST_ONCE || mqttFixedHeader.isRetain()) {
                    return new MqttFixedHeader(mqttFixedHeader.messageType(), false, MqttQoS.AT_MOST_ONCE, false, mqttFixedHeader.remainingLength());
                }
                return mqttFixedHeader;
            }
            case PUBREL: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                if (mqttFixedHeader.isRetain()) {
                    return new MqttFixedHeader(mqttFixedHeader.messageType(), mqttFixedHeader.isDup(), mqttFixedHeader.qosLevel(), false, mqttFixedHeader.remainingLength());
                }
                return mqttFixedHeader;
            }
        }
        return mqttFixedHeader;
    }

    private MqttCodecUtil() {
    }
}

