/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClientConfig;
import org.tio.core.ChannelContext;
import org.tio.utils.thread.pool.DefaultThreadFactory;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class ReconnConf {
    private static final Logger log = LoggerFactory.getLogger(ReconnConf.class);
    private final SynThreadPoolExecutor threadPoolExecutor;
    private final LinkedBlockingQueue<ChannelContext> queue = new LinkedBlockingQueue();
    private final long interval;
    private final int retryCount;

    public ReconnConf() {
        this(5000L, 0);
    }

    public ReconnConf(long interval) {
        this(interval, 0);
    }

    public ReconnConf(long interval, int retryCount) {
        LinkedBlockingQueue tioQueue = new LinkedBlockingQueue();
        DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance((String)"tio-client-reconn", (Integer)10);
        this.threadPoolExecutor = new SynThreadPoolExecutor(1, 1, 60L, tioQueue, (ThreadFactory)defaultThreadFactory);
        this.interval = interval;
        this.retryCount = retryCount;
    }

    public static ReconnConf getReconnConf(ClientChannelContext clientChannelContext) {
        TioClientConfig tioClientConfig = (TioClientConfig)clientChannelContext.tioConfig;
        return tioClientConfig.getReconnConf();
    }

    public static ReconnConf getReconnConf(ChannelContext channelContext) {
        return ReconnConf.getReconnConf((ClientChannelContext)channelContext);
    }

    public static boolean isNeedReconn(ClientChannelContext clientChannelContext, boolean putIfNeedConn) {
        if (clientChannelContext == null) {
            return false;
        }
        ReconnConf reconnConf = ReconnConf.getReconnConf(clientChannelContext);
        if (reconnConf == null) {
            return false;
        }
        if (reconnConf.getInterval() > 0L) {
            if (reconnConf.getRetryCount() <= 0 || reconnConf.getRetryCount() > clientChannelContext.getReconnCount().get()) {
                if (putIfNeedConn) {
                    TioClientConfig tioClientConfig = (TioClientConfig)clientChannelContext.tioConfig;
                    tioClientConfig.closeds.add(clientChannelContext);
                    clientChannelContext.stat.timeInReconnQueue = System.currentTimeMillis();
                    reconnConf.getQueue().add(clientChannelContext);
                }
                return true;
            }
            log.info("\u4e0d\u9700\u8981\u91cd\u8fde{}", (Object)clientChannelContext);
            return false;
        }
        return false;
    }

    public static boolean put(ClientChannelContext clientChannelContext) {
        if (clientChannelContext == null) {
            return false;
        }
        return ReconnConf.isNeedReconn(clientChannelContext, true);
    }

    public long getInterval() {
        return this.interval;
    }

    public LinkedBlockingQueue<ChannelContext> getQueue() {
        return this.queue;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public SynThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }
}

