/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.utils.thread.pool.AbstractSynRunnable;

public class ReconnRunnable
extends AbstractSynRunnable {
    private static final Logger log = LoggerFactory.getLogger(ReconnRunnable.class);
    final ClientChannelContext channelContext;
    final TioClient tioClient;

    ReconnRunnable(ClientChannelContext channelContext, TioClient tioClient, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.tioClient = tioClient;
    }

    public boolean isNeededExecute() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() {
        this.channelContext.getReconnCount().incrementAndGet();
        ReentrantReadWriteLock closeLock = this.channelContext.closeLock;
        ReentrantReadWriteLock.WriteLock writeLock = closeLock.writeLock();
        writeLock.lock();
        try {
            if (!this.channelContext.isClosed) {
                return;
            }
            long start = System.currentTimeMillis();
            this.tioClient.reconnect(this.channelContext, 2);
            long end = System.currentTimeMillis();
            long iv = end - start;
            log.error("{}, \u7b2c{}\u6b21\u91cd\u8fde,\u91cd\u8fde\u8017\u65f6:{} ms", new Object[]{this.channelContext, this.channelContext.getReconnCount(), iv});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
    }
}

