/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.core.utils.TioUtils;

public class ReadCompletionHandler
implements CompletionHandler<Integer, ByteBuffer> {
    private static final Logger log = LoggerFactory.getLogger(ReadCompletionHandler.class);
    private final ChannelContext channelContext;
    private ByteBuffer readByteBuffer;

    public ReadCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.readByteBuffer = ByteBuffer.allocate(channelContext.getReadBufferSize());
        this.readByteBuffer.order(channelContext.tioConfig.getByteOrder());
    }

    @Override
    public void completed(Integer result, ByteBuffer byteBuffer) {
        if (result > 0) {
            TioConfig tioConfig = this.channelContext.tioConfig;
            if (tioConfig.statOn) {
                tioConfig.groupStat.receivedBytes.add(result.intValue());
                tioConfig.groupStat.receivedTcps.increment();
                this.channelContext.stat.receivedBytes.add(result.intValue());
                this.channelContext.stat.receivedTcps.increment();
            }
            this.channelContext.stat.latestTimeOfReceivedByte = System.currentTimeMillis();
            if (tioConfig.getTioListener() != null) {
                try {
                    tioConfig.getTioListener().onAfterReceivedBytes(this.channelContext, result);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            this.readByteBuffer.flip();
            if (this.channelContext.sslFacadeContext == null) {
                if (tioConfig.useQueueDecode) {
                    this.channelContext.decodeRunnable.addMsg(ByteBufferUtils.copy(this.readByteBuffer));
                    this.channelContext.decodeRunnable.execute();
                } else {
                    this.channelContext.decodeRunnable.setNewReceivedByteBuffer(this.readByteBuffer);
                    this.channelContext.decodeRunnable.decode();
                }
            } else {
                ByteBuffer copiedByteBuffer = null;
                try {
                    copiedByteBuffer = ByteBufferUtils.copy(this.readByteBuffer);
                    log.debug("{}, \u4e22\u7ed9SslFacade\u89e3\u5bc6:{}", (Object)this.channelContext, (Object)copiedByteBuffer);
                    this.channelContext.sslFacadeContext.getSslFacade().decrypt(copiedByteBuffer);
                }
                catch (Exception e) {
                    log.error((Object)((Object)this.channelContext) + ", " + e.getMessage() + copiedByteBuffer, (Throwable)e);
                    Tio.close(this.channelContext, (Throwable)e, e.getMessage(), ChannelContext.CloseCode.SSL_DECRYPT_ERROR);
                }
            }
            if (TioUtils.checkBeforeIO(this.channelContext)) {
                this.read();
            }
        } else if (result == 0) {
            log.error("{}, \u8bfb\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a0", (Object)this.channelContext);
            Tio.close(this.channelContext, null, "\u8bfb\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a0", ChannelContext.CloseCode.READ_COUNT_IS_ZERO);
        } else if (result == -1) {
            Tio.close(this.channelContext, null, "\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5", ChannelContext.CloseCode.CLOSED_BY_PEER);
        } else {
            Tio.close(this.channelContext, null, "\u8bfb\u6570\u636e\u65f6\u8fd4\u56de" + result, ChannelContext.CloseCode.READ_COUNT_IS_NEGATIVE);
        }
    }

    private void read() {
        if (this.readByteBuffer.capacity() == this.channelContext.getReadBufferSize()) {
            this.readByteBuffer.position(0);
            this.readByteBuffer.limit(this.readByteBuffer.capacity());
        } else {
            this.readByteBuffer = ByteBuffer.allocate(this.channelContext.getReadBufferSize());
        }
        this.channelContext.asynchronousSocketChannel.read(this.readByteBuffer, this.readByteBuffer, this);
    }

    @Override
    public void failed(Throwable exc, ByteBuffer byteBuffer) {
        Tio.close(this.channelContext, exc, "\u8bfb\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38: " + exc.getClass().getName(), ChannelContext.CloseCode.READ_ERROR);
    }

    public ByteBuffer getReadByteBuffer() {
        return this.readByteBuffer;
    }
}

