/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.cluster;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContextFilter;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.server.cluster.TioClusterVo;
import org.tio.utils.hutool.StrUtil;

public class TioClusterMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TioClusterMessageListener.class);
    private static final AtomicLong RECEIVED_TOPIC_COUNT = new AtomicLong();
    private final TioConfig tioConfig;
    private final ChannelContextFilter channelContextFilter;

    public TioClusterMessageListener(TioConfig tioConfig, ChannelContextFilter channelContextFilter) {
        this.tioConfig = tioConfig;
        this.channelContextFilter = channelContextFilter;
    }

    public void onMessage(CharSequence channel, TioClusterVo tioClusterVo) {
        String bsId;
        String channelId;
        String token;
        String userid;
        String group;
        log.info("\u6536\u5230 channel:{}, count:{}, tioClusterVo:{}", new Object[]{channel, RECEIVED_TOPIC_COUNT.incrementAndGet(), tioClusterVo});
        String clientId = tioClusterVo.getClientId();
        if (StrUtil.isBlank((CharSequence)clientId)) {
            log.error("clientId is null");
            return;
        }
        if (Objects.equals(TioClusterVo.CLIENT_ID, clientId)) {
            log.info("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f\uff0c\u5ffd\u7565\u6389,{}", (Object)clientId);
            return;
        }
        Packet packet = tioClusterVo.getPacket();
        if (packet == null) {
            log.error("packet is null");
            return;
        }
        packet.setFromCluster(true);
        boolean isToAll = tioClusterVo.isToAll();
        if (isToAll) {
            Tio.sendToAll(this.tioConfig, packet, this.channelContextFilter);
        }
        if (StrUtil.isNotBlank((CharSequence)(group = tioClusterVo.getGroup()))) {
            Tio.sendToGroup(this.tioConfig, group, packet);
        }
        if (StrUtil.isNotBlank((CharSequence)(userid = tioClusterVo.getUserid()))) {
            Tio.sendToUser(this.tioConfig, userid, packet);
        }
        if (StrUtil.isNotBlank((CharSequence)(token = tioClusterVo.getToken()))) {
            Tio.sendToToken(this.tioConfig, token, packet);
        }
        if (StrUtil.isNotBlank((CharSequence)(channelId = tioClusterVo.getChannelId()))) {
            Tio.sendToId(this.tioConfig, channelId, packet);
        }
        if (StrUtil.isNotBlank((CharSequence)(bsId = tioClusterVo.getBsId()))) {
            Tio.sendToBsId(this.tioConfig, bsId, packet);
        }
    }
}

